% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asca_plots.R
\name{asca_plots}
\alias{asca_plots}
\alias{loadingplot.asca}
\alias{scoreplot.asca}
\title{ASCA Result Methods}
\usage{
\method{loadingplot}{asca}(object, factor = 1, comps = 1:2, ...)

\method{scoreplot}{asca}(
  object,
  factor = 1,
  comps = 1:2,
  pch.scores = 19,
  pch.projections = 1,
  gr.col = 1:nlevels(object$effects[[factor]]),
  ellipsoids,
  xlim,
  ylim,
  xlab,
  ylab,
  legendpos,
  ...
)
}
\arguments{
\item{object}{\code{asca} object.}

\item{factor}{\code{integer/character} for selecting a model factor.}

\item{comps}{\code{integer} vector of selected components.}

\item{...}{additional arguments to underlying methods.}

\item{pch.scores}{\code{integer} plotting symbol.}

\item{pch.projections}{\code{integer} plotting symbol.}

\item{gr.col}{\code{integer} vector of colours for groups.}

\item{ellipsoids}{\code{character} "confidence" or "data" ellipsoids for balanced fixed effect models.}

\item{xlim}{\code{numeric} x limits.}

\item{ylim}{\code{numeric} y limits.}

\item{xlab}{\code{character} x label.}

\item{ylab}{\code{character} y label.}

\item{legendpos}{\code{character} position of legend.}
}
\value{
The plotting routines have no return.
}
\description{
Various plotting procedures for \code{\link{asca}} objects.
}
\details{
Usage of the functions are shown using generics in the examples in \code{\link{asca}}.
Plot routines are available as
\code{scoreplot.asca} and \code{loadingplot.asca}.
}
\references{
\itemize{
\item Smilde, A., Jansen, J., Hoefsloot, H., Lamers,R., Van Der Greef, J., and Timmerman, M.(2005). ANOVA-Simultaneous Component Analysis (ASCA): A new tool for analyzing designed metabolomics data. Bioinformatics, 21(13), 3043–3048.
\item Liland, K.H., Smilde, A., Marini, F., and Næs,T. (2018). Confidence ellipsoids for ASCA models based on multivariate regression theory. Journal of Chemometrics, 32(e2990), 1–13.
\item Martin, M. and Govaerts, B. (2020). LiMM-PCA: Combining ASCA+ and linear mixed models to analyse high-dimensional designed data. Journal of Chemometrics, 34(6), e3232.
}
}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
Common functions for computation and extraction of results are found in \code{\link{asca_results}}.
}
