% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unsupervised.R
\name{hpca}
\alias{hpca}
\title{Hierarchical Principal component analysis - HPCA}
\usage{
hpca(X, ncomp = 2, scale = FALSE, verbose = FALSE, ...)
}
\arguments{
\item{X}{\code{list} of input blocks.}

\item{ncomp}{\code{integer} number of components to extract.}

\item{scale}{\code{logical} indicating if variables should be scaled.}

\item{verbose}{\code{logical} indicating if diagnostic information should be printed.}

\item{...}{additional arguments for RGCCA.}
}
\value{
\code{multiblock} object including relevant scores and loadings. Relevant plotting functions: \code{\link{multiblock_plots}}
and result functions: \code{\link{multiblock_results}}.
}
\description{
This is a wrapper for the \code{RGCCA::rgcca} function for computing HPCA.
}
\details{
HPCA is a hierarchical PCA analysis which combines two or more blocks
into a two-level decomposition with block-wise loadings and scores and superlevel
common loadings and scores. The method is closely related to the supervised method MB-PLS
in structure.
}
\examples{
data(potato)
potList <- as.list(potato[c(1,2,9)])
pot.hpca   <- hpca(potList)
plot(scores(pot.hpca), labels="names")

}
\references{
Westerhuis, J.A., Kourti, T., and MacGregor,J.F. (1998). Analysis of multiblock and hierarchical PCA and PLS models. Journal of Chemometrics, 12, 301–321.
}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
Common functions for computation and extraction of results and plotting are found in \code{\link{multiblock_results}} and \code{\link{multiblock_plots}}, respectively.
}
