% Generated by roxygen2 (4.0.1): do not edit by hand
\name{lomb_scargle}
\alias{lomb_scargle}
\title{Lomb Scargle method}
\usage{
lomb_scargle(t, m, sigma, omega, weights_flag = TRUE)
}
\arguments{
\item{t}{times}

\item{m}{magnitudes}

\item{sigma}{errors}

\item{omega}{frequency}

\item{weights_flag}{boolean (TRUE to use inverse errors as weights; FALSE uses uniform weights)}
}
\description{
\code{lomb_scargle} applies the Lomb Scargle method for performing weighted nonlinear least squares in a single band using magnitude measurements recorded at irregular intervals.
}
\examples{
n <- 1e3
set.seed(12345)
sigma <- runif(n)
t <- cumsum(runif(n))
A <- 2.3
rho <- 0.1
omega <- 0.2
beta0 <- 0.3
m <- beta0 + A*sin(omega*t + rho) + sigma*rnorm(n)
plot(t,m,xlab='time',ylab='magnitude',main='Simulated Light Curve',pch=16)

## Try several omega
nOmega <- 500
omega_seq <- seq(0.1,0.3,length=nOmega)
sol_ls <- vector(mode="list",length=nOmega)
RSS_seq <- double(nOmega)
for (i in 1:nOmega) {
  sol_ls[[i]] <- lomb_scargle(t,m,sigma,omega_seq[i])
  RSS_seq[i] <- sol_ls[[i]]$RSS
}

plot(omega_seq,RSS_seq,xlab=expression(omega),ylab='RSS',pch=16)
ix_min <- which(RSS_seq==min(RSS_seq))
sol_final <- sol_ls[[ix_min]]
}

