% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unitSphere_innerProduct1.R
\docType{class}
\name{unitSphere_innerProduct1-class}
\alias{unitSphere_innerProduct1-class}
\alias{unitSphere_innerProduct1}
\title{An S4 class to represent the function \eqn{(\vec{x}\cdot\vec{a})(\vec{x}\cdot\vec{b})} on \eqn{S^{n-1}}}
\description{
Implementation of the function
\deqn{f \colon S^{n-1} \to R,\, \vec{x} \mapsto f(\vec{x}) = (\vec{x}\cdot\vec{a})(\vec{x}\cdot\vec{b}),}
where \eqn{n \in \{1,2,3,\ldots\}} is the dimension of the integration domain \eqn{S^{n-1} = \{\vec{x}\in R^n : \Vert \vec{x} \Vert_2 = 1\}} and \eqn{\vec{a}} and \eqn{\vec{b}} are two \eqn{n}-dimensional parameter vectors.
The integral is known to be
\deqn{\int_{S^{n-1}} f(\vec{x}) d\vec{x} = \frac{2\pi^{n/2}(\vec{a}\cdot\vec{b})}{n\Gamma(n/2)},}
where \eqn{\vec{a}\in R^n} and \eqn{\vec{b}\in R^n}.
}
\details{
Due to the difficulty of testing \eqn{\Vert \vec{x} \Vert_2 = 1} in floating point arithmetic this class also implements the function "domainCheckP".
This allows to pass a list with an additional non-negative parameter "eps" representing a non-negative real number \eqn{\varepsilon} and allows to test \eqn{1-\varepsilon \leq \Vert \vec{x} \Vert_2 \leq 1+\varepsilon}.
See also the documentation of the function "checkUnitSphere" that is used to perform the checks.

The instance needs to be created with three parameters representing the dimension \eqn{n} and the two \eqn{n}-dimensional (real) vectors \eqn{\vec{a}} and \eqn{\vec{b}}.
}
\section{Slots}{

\describe{
\item{\code{dim}}{An integer that captures the dimension}

\item{\code{a}}{A \eqn{n}-dimensional real vector}

\item{\code{b}}{A \eqn{n}-dimensional real vector}
}}

\examples{
n <- as.integer(3)
f <- new("unitSphere_innerProduct1",dim=n,a=c(1,2,3),b=c(-1,-2,-3))
}
\author{
Klaus Herrmann
}
