% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutation_sctest.R
\name{permutation_sctest}
\alias{permutation_sctest}
\title{A score-based DIF test using the permutation approach.}
\usage{
permutation_sctest(
  resp,
  theta = NULL,
  a = rep(1, length(b)),
  b,
  c = rep(0, length(b)),
  DIF_covariate = NULL,
  parameters = c("per_item", "ab", "a", "b"),
  item_selection = NULL,
  nSamples = 1000,
  theta_method = c("wle", "mle", "eap", "map"),
  slope_intercept = FALSE,
  statistic = "auto",
  meanCenter = TRUE,
  decorrelate = FALSE,
  impact_groups = rep(1, dim(resp)[1])
)
}
\arguments{
\item{resp}{A matrix (or data frame) containing the responses, with the
items in the columns.}

\item{theta}{A vector with the true/estimated ability parameters or NULL
(the default) which leads to the ability parameters being estimated.}

\item{a}{A vector of item slopes/item discriminations.}

\item{b}{A vector of item locations/item difficulties.}

\item{c}{A vector of pseudo guessing parameters.}

\item{DIF_covariate}{A list with the person covariate(s) to test for as
element(s).}

\item{parameters}{A character string, either "per_item", "ab", "a", or "b",
to specify which parameters should be tested for.}

\item{item_selection}{A character vector with the column names or an integer
vector with the column numbers in the \code{resp}, specifying the items for
which the test should be computed. When set to NULL (i.t., the default),
all the items are tested.}

\item{nSamples}{An integer value with the number of permutations to be
sampled.}

\item{theta_method}{A character string, either "wle", "mle", "eap", of
"map" that specifies the estimator for the ability estimation. Only
relevant when \code{theta == NULL}.}

\item{slope_intercept}{A logical value indicating whether the slope-intercept
formulation of the 2-/3-PL model should be used.}

\item{statistic}{A character string, either "auto", "DM", "CvM",
"maxLM", "LMuo", "WDMo", or "maxLMo", specifying the test statistic to be used.}

\item{meanCenter}{A logical value: should the score contributions be mean
centered per parameter?}

\item{decorrelate}{A logical value: should the score contributions be
decorrelated?}

\item{impact_groups}{A vector indicating impact-group membership for
each person.}
}
\value{
a list with four elements:
\describe{
  \item{\code{statistics}}{A matrix containing all the test statistics.}
  \item{\code{p}}{A matrix containing the obtained \emph{p}-values.}
  \item{\code{nSamples}}{The number of samples taken.}
  \item{\code{DIF_covariate}}{A list containing all the covariate(s) used to order
   the score contributions, as well as the used test statistics.}
}
}
\description{
\code{permutation_sctest} computes score test to detect DIF in multiple
item/parameters with respect to multiple person covariates (\code{DIF_covariate}).
To obtain the p-values a resampling approach is applied. That is, person
orders are randomly permuted to sample from the test statistic distribution
under the null hypothesis. The
functionality is limited to the 1-, 2-, and 3-parameter logistic models.
Only DIF with respect to the \code{a} and \code{b} parameters are tested for,
respectively the item discriminations and the item difficulties.
}
\details{
Author: Dries Debeer
}
\examples{
\donttest{
data("toydata")
resp <- toydata$resp
group_categ <- toydata$group_categ
it <- toydata$it
discr <- it[,1]
diff <- it[,2]

permutation_sctest(resp = resp, DIF_covariate = group_categ, a = discr, b = diff, 
decorrelate = FALSE)
}

}
\seealso{
\code{\link{bootstrap_sctest}}
}
