% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mssm.R
\name{logLik.mssm}
\alias{logLik.mssm}
\alias{logLik.mssmLaplace}
\title{Approximate Log-likelihood for a mssm Object}
\usage{
\method{logLik}{mssm}(object, ...)

\method{logLik}{mssmLaplace}(object, ...)
}
\arguments{
\item{object}{an object of class \code{mssm} or \code{mssmLaplace}.}

\item{...}{un-used.}
}
\value{
A \code{logLik} object. The \code{log_lik_terms} attribute contains
the log-likelihood contributions from each time point.

The degrees of freedom assumes that all parameters are free. The number of
observations may be invalid for some models (e.g., discrete survival
analysis).
}
\description{
Function to extract the log-likelihood from a \code{mssm} or
\code{mssmLaplace} object.
}
\examples{
if(require(Ecdat)){
 # load data and fit glm to get starting values
 data("Gasoline", package = "Ecdat")
 glm_fit <- glm(lgaspcar ~ factor(country) + lincomep + lrpmg + lcarpcap,
                Gamma("log"), Gasoline)

 # get object to perform estimation
 library(mssm)
 ll_func <- mssm(
   fixed = formula(glm_fit), random = ~ 1, family = Gamma("log"),
   data = Gasoline, ti = year, control = mssm_control(
     N_part = 1000L, n_threads = 1L))

 # fit model with time-varying intercept with Laplace approximation
 disp <- summary(glm_fit)$dispersion
 laplace <- ll_func$Laplace(
   cfix = coef(glm_fit), disp = disp, F. = diag(.5, 1), Q = diag(1))

 # run particle filter
 pf <- ll_func$pf_filter(
   cfix = laplace$cfix, disp = laplace$disp, F. = laplace$F., Q = laplace$Q)

 # compare approximate log-likelihoods
 print(logLik(pf))
 print(logLik(laplace))
}
}
