% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mssm.R
\name{mssm_control}
\alias{mssm_control}
\title{Auxiliary for Controlling Multivariate State Space Model Fitting}
\usage{
mssm_control(N_part = 1000L, n_threads = 1L, covar_fac = 1.2,
  ftol_rel = 0.000001, nu = 8, what = "log_density",
  which_sampler = "mode_aprx", which_ll_cp = "no_aprx", seed = 1L,
  KD_N_max = 10L, aprx_eps = 0.001, ftol_abs = 0.0001,
  ftol_abs_inner = 0.0001, la_ftol_rel = -1, la_ftol_rel_inner = -1,
  maxeval = 10000L, maxeval_inner = 10000L)
}
\arguments{
\item{N_part}{integer greater than zero for the number of particles to use.}

\item{n_threads}{integer greater than zero for the number of threads to use.}

\item{covar_fac}{positive numeric scalar used to scale the covariance
matrix in the proposal distribution.}

\item{ftol_rel}{positive numeric scalar with convergence threshold passed
to \code{\link{nloptr}} if the mode approximation method is used for the
proposal distribution.}

\item{nu}{degrees of freedom to use for the multivariate
\eqn{t}-distribution that is used as the proposal distribution. A
multivariate normal distribution is used if \code{nu <= 2}.}

\item{what}{character indicating what to approximate. \code{"log_density"}
implies only the log-likelihood. \code{"gradient"} also yields a gradient
approximation. \code{"Hessian"} also yields an approximation of the
observed information matrix.}

\item{which_sampler}{character indicating what type of proposal
distribution to use. \code{"mode_aprx"} yields a Taylor approximation at
the mode. \code{"bootstrap"} yields a proposal distribution similar to the
common bootstrap filter.}

\item{which_ll_cp}{character indicating what type of computation should be
performed in each iteration of the particle filter. \code{"no_aprx"} yields
no approximation. \code{"KD"} yields an approximation using a dual k-d tree
method.}

\item{seed}{integer with seed to pass to \code{\link{set.seed}}.}

\item{KD_N_max}{integer greater than zero with the maximum number of
particles to include in each leaf of the two k-d trees if the dual k-d trees
method is used.}

\item{aprx_eps}{positive numeric scalar with the maximum error if the
dual k-d tree method is used.}

\item{ftol_abs, ftol_abs_inner, la_ftol_rel, la_ftol_rel_inner, maxeval, maxeval_inner}{scalars passed to \code{nlopt} when estimating parameters with a Laplace
approximation. The \code{_inner} denotes the values passed in the inner
mode estimation. The mode estimation is done with a custom Newton–Raphson
method}
}
\description{
Auxiliary function for \code{\link{mssm}}.
}
\examples{
library(mssm)
str(mssm_control())
str(mssm_control(N_part = 2000L))
}
\seealso{
\code{\link{mssm}}.

See the README of the package for details of the dual k-d tree method
at \url{https://github.com/boennecd/mssm}.
}
