\name{martCV}
\alias{martCV}
\title{ cross-validation for MART }
\description{
 Get the cross-validation R squared for MART.
}
\usage{
martCV(data, fold = 5, seed = 281142, shrinkage = 0.06, interaction.depth = 10, n.trees = 2000, small_count = 0.5)
}
\arguments{
  \item{data}{ the data frame generated by \code{expData.R} }
  \item{fold}{ number of fold for CV }
  \item{seed}{ seed to generate training indexes }
  \item{shrinkage}{ the \code{shrinkage} argument of gbm }
  \item{interaction.depth}{ the \code{interaction.depth} argument of gbm }
  \item{n.trees}{ the \code{n.trees} argument of gbm }
  \item{small_count}{ the small count which will replace the zero count }
}
\value{
 the CV R squared, a numeric value
}
\examples{
 # read and expand the data
 data(g1_part) # for real data, please use read.csv, like g1 <- read.csv("g1.csv")
 data <- expData(g1_part, 2, 3) # In real datasets, surrounding sequences should be set longer.
 
 # To shorten the running time, this example uses small values of interaction.depth and n.trees. For real datasets, it is strongly suggested to use their default values.
 # get the CV R squared for MART
 R_sq <- martCV(data, interaction.depth = 2, n.trees = 100)
}
\keyword{ models }
\keyword{ tree }
