% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrfi_methods.R
\name{+,mrfi,numeric-method}
\alias{+,mrfi,numeric-method}
\alias{-,mrfi,numeric-method}
\alias{+,mrfi,mrfi-method}
\alias{-,mrfi,mrfi-method}
\title{Set operations for \code{mrfi} objects}
\usage{
\S4method{+}{mrfi,numeric}(e1, e2)

\S4method{-}{mrfi,numeric}(e1, e2)

\S4method{+}{mrfi,mrfi}(e1, e2)

\S4method{-}{mrfi,mrfi}(e1, e2)
}
\arguments{
\item{e1}{A \code{mrfi} object.}

\item{e2}{Either a second \code{mrfi} object or a length 2 \code{numeric} with the new
relative position to include (\code{+}) or remove (\code{-}).}
}
\description{
Provides simple operations to include (in the sense of union)
new interacting positions to a \code{mrfi} object with the \code{'+'} operator and
remove positions (set difference) with \code{-}. Individual positions can be
included/excluded using length-2 vectors in the right hand side. Union and
set difference of complete structures can also be computed by adding or
subtracting two \code{mrfi} objects.

This operations deal with opposite directions filtering to avoid redundancy
in the interaction structure.
}
\examples{
mrfi(1) + c(2,0)
mrfi(1) - c(1,0)
mrfi(1) + mrfi(0, positions = list(c(2,0)))
mrfi(2) - mrfi(1)
}
