% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CImap.R
\name{CImap}
\alias{CImap}
\title{Computation of simultaneous credible intervals.}
\usage{
CImap(smoothVec, mm, nn, prob = 0.95)
}
\arguments{
\item{smoothVec}{Differences of smooths at neighboring scales.}

\item{mm}{Number of rows of the original input object.}

\item{nn}{Number of columns of the original input object.}

\item{prob}{Credibility level for the posterior credibility analysis. 
By default \code{prob = 0.95}.}
}
\value{
An array with simultaneous credible intervals \code{VmapCI} and
    the dimensions of the original input object, \code{mm} and \code{nn}.
}
\description{
Simultaneous credible intervals for all differences of smooths at neighboring
scales \eqn{z_{i}} are computed.
}
\details{
\code{CImap} is an internal function of \code{\link{mrbsizeRgrid}} and is usually
not used independently. The output can be analyzed with the plotting function 
\code{\link{plot.CImapGrid}}.
}
\examples{
# Artificial sample data: 10 observations (5-by-2 object), 10 samples
set.seed(987)
sampleData  <- matrix(stats::rnorm(100), nrow = 10)
sampleData [4:6, ] <- sampleData [4:6, ] + 5

# Calculation of the simultaneous credible intervals
CImap(smoothVec = sampleData , mm = 5, nn = 2, prob = 0.95)

}
