% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_CV_RT.R
\name{get_CV_RT}
\alias{get_CV_RT}
\title{Retention time precision}
\usage{
get_CV_RT(input_list)
}
\arguments{
\item{input_list}{A list with data frames and respective retention time information.}
}
\value{
This function returns the original submitted data of the \code{input_list} including a new output column:
\itemize{
\item CV_Retention.time_mpwR - coefficient of variation in percentage.
}
}
\description{
Calculate retention time precision
}
\details{
For each submitted data the coefficient of variation is calculated on precursor-level for retention time. Only full profiles are included.
}
\examples{
# Load libraries
library(tibble)

# Example data
set.seed(123)
data <- list(
  Spectronaut = list(
     filename = "C",
     software = "Spectronaut",
     data = list(
        "Spectronaut" = tibble::tibble(
           Run_mpwR = rep(c("A","B"), times = 5),
           Precursor.IDs_mpwR = rep(c("A2", "A3", "B2", "B3", "C1"), each = 2),
           Peptide.IDs_mpwR = rep(c("A", "B", "C", "D", "E"), each = 2),
           ProteinGroup.IDs_mpwR = rep(c("A", "B", "C", "D", "E"), each = 2),
           Retention.time_mpwR = sample(1:20, 10),
           Peptide_LFQ_mpwR = sample(1:30, 10),
           ProteinGroup_LFQ_mpwR = sample(1:30, 10))
     )
  )
)

# Result
output <- get_CV_RT(
  input_list = data
)
}
\author{
Oliver Kardell
}
