% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results.R
\name{results}
\alias{results}
\title{Extract simulation results from RAMAS Metapop .mp files}
\usage{
results(mp)
}
\arguments{
\item{mp}{A character string containing the path to a RAMAS Metapop .mp file 
containing simulation results. Metapop .mp files are plain text files that
store settings describing RAMAS metapopulation models, and the results of 
simulating population dynamics according to those models.}
}
\value{
A \code{list} containing: \item{version}{The version of RAMAS Metapop 
  from which the file indicated by \code{mp} originated (if
  identifiable).}\item{results}{An array containing simulation results
  extracted from \code{file}. The number of rows is equal to the number of
  time steps in the simulation. The array has four columns, containing mean,
  sd, min and max of population size across iterations at each time step
  (i.e. each row), and the number of array slices is equal to the number of
  populations. The third dimension is named according to population names
  (numeric component only).} \item{iter_min}{A sorted vector of minimum
  abundance, across time steps, for each iteration.} \item{iter_max}{A sorted
  vector of maximum abundance, across time steps, for each iteration.}
  \item{iter_terminal}{A sorted vector of terminal abundance for each
  iteration.} \item{qe_thr}{The quasi-extinction threshold. When the total
  abundance is beneath \code{qe_thr}, the metapopulation is considered to be
  quasi-extinct.} \item{qe_prob}{The probability and cumulative probability
  of exceeding the quasi-extinction threshold (\code{qe_thr}) at each time
  step.} \item{EMA}{The mean minimum abundance (i.e. the mean, across
  iterations, of the minimum abundance for each simulation trajectory).}
  \item{SDMA}{The standard deviation of minimum abundance (i.e. the sd,
  across iterations, of the minimum abundance for each simulation
  trajectory).} \item{timestamp}{A POSIXlt object representing the date and
  time at which the simulation was completed.} \item{n_pops}{The number of
  populations in the simulation.} \item{duration}{The number of time steps in
  the simulation} \item{n_iters}{The number of iterations performed.}
}
\description{
Extract population size simulation results (mean, sd, min and max), including 
expected minimum abundance (EMA) and its standard deviation, from a RAMAS 
Metapop .mp file.
}
\note{
\code{mptools} has been tested with outputs generated by RAMAS Metapop
version 5, and may produce unexpected results for other versions. A warning
is issued if the user attempts to access files originating from other 
versions of RAMAS Metapop.
}
\examples{
mp <- system.file('example.mp', package='mptools')
res <- results(mp)
str(res)

# look at the simulation results for the first array slice (NB: this slice is
# all pops combined):
res$results[,, 1]
# equivalently, subset by name:
res$results[,, 'ALL']
res$results[,, 'Pop 190']
res$results[,, '240A24']
dimnames(res$results)[[3]] # population names

# return a matrix of mean population sizes, where columns represent
# populations and rows are time steps:
res$results[, 1, ] # or res$results[, 'mean', ]

# sd across iterations:
res$results[, 2, ] # or res$results[, 'sd', ]

# min pop sizes across iterations:
res$results[, 3, ] # or res$results[, 'min', ]

# max pop sizes across iterations:
res$results[, 4, ] # or res$results[, 'max', ] 
}
\references{
\itemize{
  \item{Akcakaya, H. R., Burgman, M. A., Kindvall, O., Wood, C. C., 
  Sjogren-Gulve, P., Hatfield, J. S., & McCarthy, M. A. (2004). \emph{Species
  Conservation and Management: Case Studies}. New York: Oxford University
  Press.}
  \item{\href{https://www.ramas.com/ramas.htm#metapop}{RAMAS Software}}
  \item{\href{https://www.ramas.com/gis-faq.htm}{RAMAS GIS and RAMAS Metapop
  Frequently Asked Questions}}
}
}
\seealso{
\code{\link{meta}}
}

