% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_lambdas.R
\name{comp_lambdas}
\alias{comp_lambdas}
\title{Solve for Lambda for a Particular Mean Parametrized COM-Poisson Distribution}
\usage{
comp_lambdas(mu, nu, lambdalb = 1e-10, lambdaub = 1900,
  maxlambdaiter = 1000, tol = 1e-06, lambdaint = 1)
}
\arguments{
\item{mu, nu}{mean and dispersion parameters. Must be straightly positive.}

\item{lambdalb, lambdaub}{numeric; the lower and upper end points for the interval to be
searched for lambda(s).}

\item{maxlambdaiter}{numeric; the maximum number of iterations allowed to solve 
for lambda(s).}

\item{tol}{numeric; the convergence threshold. A lambda is said to satisfy the 
mean constraint if the absolute difference between the calculated mean and the 
corresponding mu values is less than tol.}

\item{lambdaint}{numeric vector; initial gauss for lambda(s).}
}
\value{
The function returns the lambda value(s) that satisfies the mean constraint(s).
}
\description{
Given a particular mean parametrized COM-Poisson distribution i.e. mu and nu, 
this function is used to find a lambda that can satisfy the mean constraint with a 
combination of bisection and Newton-Raphson updates. The function is also vectorized but
will only update those that have not converged.
}
