% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensor_functions.R
\name{device_info}
\alias{device_info}
\title{Get the device info for one or more participants}
\usage{
device_info(db, participant_id = NULL)
}
\arguments{
\item{db}{A database connection to an m-Path Sense database.}

\item{participant_id}{A character string identifying a single participant. Use
\code{\link[mpathsenser]{get_participants}} to retrieve all participants from the database.
Leave empty to get data for all participants.}
}
\value{
A tibble containing device info for each participant
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{
\dontrun{
# Open the database
db <- open_db("path/to/db")

# Get device info for all participants
device_info(db)

# Get device info for a specific participant
device_info(db, participant_id = 1)
}
}
