% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detailedPedigree-class.R
\name{detailedPedigree-class}
\alias{detailedPedigree-class}
\alias{detailedPedigree}
\title{Pedigree for simulation}
\usage{
detailedPedigree(lineNames, mother, father, initial, observed, selfing)
}
\arguments{
\item{lineNames}{The names assigned to the lines.}

\item{mother}{The female parent of this line, given by name or by index within \code{lineNames}.}

\item{father}{The male parent of this line, given by name or by index within \code{lineNames}.}

\item{initial}{The founder lines, given by name or by index within lineNames.}

\item{observed}{The lines which are observed in the final population, given by name or by index within lineNames.}

\item{selfing}{Value determining whether or not subsequent analysis of populations generated from this pedigree should assume infinite generations of selfing. Possible values are \code{"finite"} and \code{"infinite"}.}
}
\value{
An object of class \code{detailedPedigree}, suitable for simulation.
}
\description{
Class detailedPedigree is similar to the S4 class pedigree, except it also contains information about which lines are going to observed. This allows simulation of a data set with the given pedigree.
}
\section{Functions}{
\itemize{
\item \code{detailedPedigree}: Construct object of class detailedPedigree
}}

\section{Slots}{

\describe{
\item{\code{initial}}{The indices of the inbred founder lines in the pedigree. These founders lines must be the first lines in the pedigree.}

\item{\code{observed}}{A logical vector with one value per line in the pedigree. A value of \code{TRUE} indicates that this line will be genotyped.}
}}

\examples{
lineNames <- paste0("L", 1:10)
mother <- c(0, 0, 1, rep(3, 7))
father <- c(0, 0, 2, rep(2, 7))
initial <- 1:2
lineNames <- paste0("L", 1:10)
observed <- c(rep(FALSE, 3), rep(TRUE, 7))
detailedPedigreeObj <- detailedPedigree(mother = mother, father = father, initial = initial, 
	observed = observed, lineNames = lineNames, selfing = "finite")
}
\seealso{
\code{\link[mpMap2]{pedigree-class}}, \code{\link[mpMap2]{simulateMPCross}}, \code{\link[mpMap2]{detailedPedigree}}

\code{\link[mpMap2]{detailedPedigree-class}}
}
