\name{sim.sigthr}
\alias{sim.sigthr}
\title{Simulate a significance threshold for (composite) interval mapping}
\usage{
  sim.sigthr(mpcross, nsim = 100, alpha = 0.05, pindex = 1,
    step = 0, ncov = 0, ...)
}
\arguments{
  \item{mpcross}{Object of class \code{mpcross}}

  \item{nsim}{Number of null datasets to simulate; default
  is 100}

  \item{alpha}{Significance threshold for QTL p-values}

  \item{pindex}{Index of phenotype (if more than one in
  dataset)}

  \item{step}{Step size at which to compute the QTL
  profile. Default is 0, at midpoints of marker intervals}

  \item{ncov}{Number of marker covariates to search for -
  default is 0 for interval mapping}

  \item{...}{Additional arguments}
}
\value{
  List with components: \item{alpha}{Input significance
  threshold} \item{nsim}{Input number of simulated
  datasets} \item{minp}{Genomewide minimum p-value for each
  simulated dataset} \item{thr}{Empirical p-value
  threshold}
}
\description{
  Generate a significance threshold by simulating from the
  null hypothesis. Phenotypic values for the observed
  genetic data are simulated to represent data with no QTL,
  and a genomewide p-value threshold is calculated.
}
\seealso{
  \code{\link[mpMap]{mpIM}}
}

