% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula-utils.R
\name{reop_formula}
\alias{reop_formula}
\title{Insert Inhibition of Interpretation/Conversion into formulas}
\usage{
reop_formula(x, ops = c("/", "*", "^"))
}
\arguments{
\item{x}{a formula (or a call of length 2 or 3, for recursive processing of formulas).
Other objects are returned unchanged.}

\item{ops}{a vector of character representions of operators to be inhibited.}
}
\value{
a formula with \code{I()} inserted where required to inhibit interpretation/conversion.
}
\description{
\code{model.frame()} assumes that certain operations (e.g. \code{/}, \code{*}, \code{^}) have special
meanings.  These can be inhibited using \code{I()}.  This function inserts \code{I()} into
a formula when encountering a specified operator or parens.
}
\examples{
reop_formula(y ~ x * y)
reop_formula(y ~ (x * y))
reop_formula(y ~ x ^ y)
reop_formula(y ~ x * y ^ z)

}
