#' Gross Domestic Product of the United Kingdom over a millenium
#'
#' An estimate of the real GDP of the United Kingdom over about 7 centuries. "Real"
#' means adjusted for inflation. Take such estimates with a large amount of salt, since
#' pre-industrial era data is very limited and because the components of GDP change substantially
#' over a few decades, let alone a few centuries. Also, the name `UK_GDP` is anachronistic,
#' since for most of the record is before the UK was created as a political entity.
#'
#' @docType data
#' @name UK_GDP
#' @usage data(UK_GDP)
#'
#' @keywords datasets
#'
#' @format
#'   A data frame with 747 rows
#'   \itemize{
#'     \item{\code{year}} {Which year the estimate is for.}
#'     \item{\code{GDP}} {*per capita* Gross domestic product in GBP (pounds)}
#'     }
#'
"UK_GDP"
