% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpqrdist.R
\name{pdist}
\alias{pdist}
\alias{xpgamma}
\alias{xpt}
\alias{xpchisq}
\alias{xpf}
\alias{xpbinom}
\alias{xppois}
\alias{xpgeom}
\alias{xpnbinom}
\alias{xpbeta}
\title{Illustrated probability calculations from distributions}
\usage{
pdist(dist = "norm", q, plot = TRUE, verbose = FALSE, invisible = FALSE,
  digits = 3L, xlim, ylim, resolution = 500L, return = c("values",
  "plot"), ..., refinements = list())

xpgamma(...)

xpt(...)

xpchisq(...)

xpf(...)

xpbinom(...)

xppois(...)

xpgeom(...)

xpnbinom(...)

xpbeta(...)
}
\arguments{
\item{dist}{a character description of a distribution, for example
\code{"norm"}, \code{"t"}, or \code{"chisq"}}

\item{q}{a vector of quantiles}

\item{plot}{a logical indicating whether a plot should be created}

\item{verbose}{a logical}

\item{invisible}{a logical}

\item{digits}{the number of digits desired}

\item{xlim}{x limits}

\item{ylim}{y limits}

\item{resolution}{Number of points used for detecting discreteness and generating plots.
The default value of 5000 should work well except for discrete distributions
that have many distinct values, especially if these values are not evenly spaced.}

\item{return}{If \code{"plot"}, return a plot.  If \code{"values"}, return a vector of numerical values.}

\item{...}{Additional arguments, including parameters of the distribution
and additional options for the plot}

\item{refinements}{A list of refinements to the plot.  See \code{\link[ggformula:gf_refine]{ggformula::gf_refine()}}.}
}
\value{
A vector of probabilities; a plot is printed as a side effect.
}
\description{
Illustrated probability calculations from distributions
}
\details{
The most general function is \code{pdist} which can work with
any distribution for which a p-function exists.  As a convenience, wrappers are
provided for several common distributions.
}
\examples{
pdist("norm", -2:2)
pdist("norm", seq(80,120, by = 10), mean = 100, sd = 10)
pdist("chisq", 2:4, df = 3)
pdist("f", 1, df1 = 2, df2 = 10)
pdist("gamma", 2, shape = 3, rate = 4)
}
\seealso{
\code{\link[=qdist]{qdist()}}, \code{\link[=xpnorm]{xpnorm()}}, \code{\link[=xqnorm]{xqnorm()}}.
}
