% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xhistogram.R
\name{xhistogram}
\alias{xhistogram}
\alias{histogram}
\alias{xhistogramBreaks}
\alias{prepanel.xhistogram}
\alias{panel.xhistogram}
\title{Augmented histograms}
\usage{
xhistogram(...)

xhistogramBreaks(x, center = NULL, width = NULL, nint, ...)

prepanel.xhistogram(x, breaks = xhistogramBreaks, ...)

panel.xhistogram(x, dcol = trellis.par.get("plot.line")$col, dalpha = 1,
  dlwd = 2, gcol = trellis.par.get("add.line")$col, glwd = 2,
  fcol = trellis.par.get("superpose.polygon")$col, dmath = dnorm,
  verbose = FALSE, dn = 100, args = NULL, labels = FALSE,
  density = NULL, under = FALSE, fit = NULL, start = NULL,
  type = "density", v, h, groups = NULL, center = NULL, width = NULL,
  breaks, nint = round(1.5 * log2(length(x)) + 1), stripes = c("vertical",
  "horizontal", "none"), alpha = 1, ...)
}
\arguments{
\item{\dots}{additional arguments passed from \code{\link[lattice:histogram]{lattice::histogram()}}
to the panel function; by default when the \pkg{mosaic} package has been loaded this will
\code{\link[=panel.xhistogram]{panel.xhistogram()}}.}

\item{x}{a formula or a numeric vector}

\item{center}{center of one of the bins}

\item{width}{width of the bins}

\item{nint}{approximate number of bins}

\item{breaks}{break points for histogram bins, a function for computing such,
or a method \code{\link[=hist]{hist()}} knows about given as a character string.
When using the \pkg{mosaic} package defaults,
\code{\link[mosaic:xhistogramBreaks]{mosaic::xhistogramBreaks()}} is used.}

\item{dcol}{color of density curve}

\item{dalpha}{alpha for density curve}

\item{dlwd, glwd}{like \code{lwd} but affecting the density line and guide lines, respectively}

\item{gcol}{color of guidelines}

\item{fcol}{fill colors for histogram rectangles when using \code{groups}.
(Use \code{col}, which is passed through to \url{panel.histogram()}, when
not using \code{groups}.}

\item{dmath}{density function for density curve overlay}

\item{verbose}{be verbose?}

\item{dn}{number of points to sample from density curve}

\item{args}{a list of additional arguments for \code{dmath}}

\item{labels}{should counts/densities/precents be displayed or each bin?}

\item{density}{a logical indicating whether to overlay a density curve}

\item{under}{a logical indicating whether the density layers should be under or
over other layers of the plot.}

\item{fit}{a character string describing the distribution to fit.  Known distributions include
\code{"exponential"}, \code{"normal"}, \code{"lognormal"}, \code{"poisson"}, \code{"beta"}, \code{"geometric"},
\code{"t"}, \code{"weibull"}, \code{"cauchy"}, \code{"gamma"}, \code{"chisq"}, and \code{"chi-squared"}}

\item{start}{numeric value passed to \code{\link[MASS:fitdistr]{MASS::fitdistr()}}}

\item{type}{one of \code{'density'}, \code{'count'}, or \code{'percent'}}

\item{h, v}{a vector of values for additional horizontal and vertical lines}

\item{groups}{as per \code{\link[lattice:histogram]{lattice::histogram()}}}

\item{stripes}{one of \code{"vertical"}, \code{"horizontal"}, or \code{"none"}, indicating
how bins should be striped when \code{groups} is not \code{NULL}}

\item{alpha}{transparency level}

\item{panel}{a panel function}
}
\value{
\code{xhistogramBreaks} returns a vector of break points
}
\description{
The \pkg{mosaic} package adds some additional functionality to
\code{\link[lattice:histogram]{lattice::histogram()}}, making it simpler to obtain certain common
histogram adornments.  This is done be resetting the default panel
and prepanel functions used by histogram.
}
\details{
The primary additional functionality added to \code{\link[=histogram]{histogram()}}
are the arguments \code{width} and \code{center} which provide a simple
way of describing equal-sized bins, and \code{fit} which can be used to
overlay the density curve for one of several distributions.  The
\code{groups} argument can be used to color the bins.  The primary use
for this is to shade tails of histograms, but there may be other uses
as well.
}
\note{
Versions of \pkg{lattice} since 0.20-21 support setting custom defaults
for \code{breaks}, \code{panel}, and \code{prepanel} used by
\code{histogram()}, so \code{xhistogram()} is no longer needed.
As a result, \code{xhistogram()}
(which was required in earlier versions of \pkg{mosaic}
is no longer needed and has been removed.
}
\examples{
if (require(mosaicData)) {
histogram(~age | substance, HELPrct, v=35, fit='normal')
histogram(~age, HELPrct, labels=TRUE, type='count')
histogram(~age, HELPrct, groups=cut(age, seq(10,80,by=10)))
histogram(~age, HELPrct, groups=sex, stripes='horizontal')
histogram(~racegrp, HELPrct, groups=substance,auto.key=TRUE)
xhistogramBreaks(1:10, center=5, width=1)
xhistogramBreaks(1:10, center=5, width=2)
xhistogramBreaks(0:10, center=15, width=3)
xhistogramBreaks(1:100, center=50, width=3)
xhistogramBreaks(0:10, center=5, nint=5)
}
}
\seealso{
\code{\link[lattice:histogram]{lattice::histogram()}}, \code{\link[=mosaicLatticeOptions]{mosaicLatticeOptions()}},
and \code{\link[=restoreLatticeOptions]{restoreLatticeOptions()}}.
}
