% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/reproData.R
\name{reproData}
\alias{reproData}
\title{Creates a dataset for reproduction toxicity analysis}
\usage{
reproData(x)
}
\arguments{
\item{x}{a dataframe as expected by \code{survData} containing one
additional \code{Nrepro} column of class \code{integer} with positive
values only. This column should
provide the number of offspring produced since the last observation.}
}
\value{
An object of class \code{reproData}.
}
\description{
This function creates a \code{reproData} object from experimental
data provided as a \code{data.frame}. The resulting object can then be used
for plotting and model fitting. The \code{reproData} class is a sub-class
of \code{survData}, meaning that all functions and method available for
survival analysis can be used with \code{reproData} objects.
}
\details{
The \code{x} argument contains the experimental data, and should have
the same structure that the argument of \code{survData}, plus a single
additional colum providing the total number of offspring observed since the
last time point. The function fails if \code{x} does not meet the
expected requirements. Please run \code{\link{reproDataCheck}} to ensure
\code{x} is well-formed.
}
\examples{
# (1) Load reproduction dataset
data(cadmium1)

# (2) Create an object of class "reproData"
dat <- reproData(cadmium1)
dat
class(dat)
}
\keyword{transformation}

