% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morphomapCore.R
\name{morphomapCore}
\alias{morphomapCore}
\title{morphomapCore}
\usage{
morphomapCore(
  out.sur = out.sur,
  inn.sur = inn.sur,
  num.sect = 61,
  mech.len,
  clean_int_out = TRUE,
  param1 = 0.5,
  radius.fact = 2.5,
  npovs = 100,
  num.points = 500,
  start = 0.2,
  end = 0.8,
  print.progress = TRUE
)
}
\arguments{
\item{out.sur}{object of class mesh3d}

\item{inn.sur}{object of class mesh3d}

\item{num.sect}{number of sections}

\item{mech.len}{mechanical length of the long bone}

\item{clean_int_out}{logical if TRUE the inner section will be cleaned by using spherical flipping}

\item{param1}{numeric parameter for spherical flipping operator (how much the section will be deformed)}

\item{radius.fact}{numeric parameter for spherical flipping operator (distance from the center of the outline at which the povs are defined)}

\item{npovs}{numeric: number of points of view defined around the section}

\item{num.points}{number of equiengular points to be defined on each section}

\item{start}{percentage of the mechanical length from which the first section is defined}

\item{end}{percentage of the mechanical length from which the last section is defined}

\item{print.progress}{logical: if TRUE a progress bar is printed to the screen}
}
\value{
3D_out num.pointsx3xnum.sect array of the external outlines

3D_inn num.pointsx3xnum.sect array of the internal outlines

2D_out num.pointsx2xnum.sect array of the external outlines

2D_inn num.pointsx2xnum.sect array of the internal outlines

mech_length mechanical length of the long bone

start percentage of the mechanical length from which the first section is defined

end percentage of the mechanical length from which the last section is defined
}
\description{
Tool to build 3D and 2D cross sections
}
\examples{
if(interactive()){
#raw section on a human femur bone
data(HomFem38023)
meshes<-morphomapSegm(HomFem38023, param1=4)
perMesh<-meshes$external
endMesh<-meshes$internal
mech_length<-380.23
rawSections<-morphomapCore(out.sur=perMesh,
                           inn.sur=endMesh,num.sect=61,mech.len = mech_length,
                           start = 0.2,end=0.8)
#2D plot of the first section
plot(rawSections$`2D_out`[,,1],col="grey",asp=1,xlab="x",ylab="y",type="l")
points(rawSections$`2D_inn`[,,1],col="red",type="l")
#3D plot of the first section
require(rgl)
rgl::open3d()
rgl::plot3d(rawSections$`3D_out`[,,1],aspect=FALSE,col="grey",
type="l",lwd=5,xlab="x",ylab="y",zlab="z")
rgl::plot3d(rawSections$`3D_inn`[,,1],aspect=FALSE,col="red",
type="l",lwd=5,add=TRUE)

#raw section on a chimpanzee femur bone
data(PanFem27713)
meshes<-morphomapSegm(PanFem27713, param1=3)
perMesh<-meshes$external
endMesh<-meshes$internal
mech_length<-277.13
rawSections<-morphomapCore(out.sur=perMesh,
                           inn.sur=endMesh,num.sect=61,mech.len = mech_length,
                           start = 0.2,end=0.8)
#2D plot of the first section
plot(rawSections$`2D_out`[,,1],col="grey",asp=1,xlab="x",ylab="y",type="l")
points(rawSections$`2D_inn`[,,1],col="red",type="l")
#3D plot of the first section
require(rgl)
rgl::open3d()
rgl::plot3d(rawSections$`3D_out`[,,1],aspect=FALSE,col="grey",
type="l",lwd=5,xlab="x",ylab="y",zlab="z")
rgl::plot3d(rawSections$`3D_inn`[,,1],aspect=FALSE,col="red",
type="l",lwd=5,add=TRUE)
}
}
\author{
Antonio Profico, Luca Bondioli, Pasquale Raia, Paul O'Higgins, Damiano Marchi
}
