% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morphomap2Dmap.R
\name{morphomap2Dmap}
\alias{morphomap2Dmap}
\title{morphomap2Dmap}
\usage{
morphomap2Dmap(
  morphomap.shape,
  rem.out = FALSE,
  fac.out = 0.5,
  smooth = FALSE,
  scale = TRUE,
  smooth.iter = 5,
  gamMap = FALSE,
  nrow = 90,
  ncol = 100,
  gdl = 250,
  method = "equiangular",
  unwrap = "A",
  plot = TRUE,
  pal = blue2green2red(101),
  aspect = 2
)
}
\arguments{
\item{morphomap.shape}{list: output from morphomapShape function}

\item{rem.out}{logical: if TRUE the outlier will be removed}

\item{fac.out}{numeric: parameter to set the threshold in outliers detection}

\item{smooth}{logical: if TRUE a smooth filter is applied}

\item{scale}{logical: if TRUE the thichkness matrix is scaled from 0 to 1}

\item{smooth.iter}{numeric: number of smoothing iterations}

\item{gamMap}{logical: if TRUE gam smoothing is applied}

\item{nrow}{numeric: number of rows for gam smoothing}

\item{ncol}{numeric: number of columns for gam smoothing}

\item{gdl}{numeric: number of degree of freedom for gam smoothing}

\item{method}{character: if set on "equiangular" the cortical thickness is meant as the distance of the segment intersecting the external and internal outline starting from the centroid of the section. If set on "closest" the cortical thickness is calculated at each point as the closest distance between external and internal outlines}

\item{unwrap}{character: starting qaudrant to unwrap the diaphysis ("A"=anterior, "L"=lateral, "P"=posterior, "M"=mesial)}

\item{plot}{logical: if TRUE the 2D morphometric map is plotted}

\item{pal}{character vector: colors to be used in the map production}

\item{aspect}{numeric: axis ratio for 2D morphometric map}
}
\value{
dataframe dataframe for colormap production

2Dmap thickness color map

gamoutput output from GAM

data input used to build the GAM map
}
\description{
Create a 2D cortical thickness map
}
\examples{
\donttest{
library(colorRamps)
#morphomap on a human femur bone
data(HomFem38023)
meshes<-morphomapSegm(HomFem38023, param1=4)
perMesh<-meshes$external
endMesh<-meshes$internal
mech_length<-380.23
rawSections<-morphomapCore(out.sur=perMesh,
inn.sur=endMesh,num.sect=61,mech.len = mech_length, start = 0.2,end=0.8)
shapeSections<-morphomapShape(rawSections,24,sects_vector=NULL,cent.out="CCA",
delta=0.1, side="left")

#built 2D morphometric map without GAM smoothing
bone2Dmap<-morphomap2Dmap(morphomap.shape=shapeSections,
                          plot = TRUE, rem.out = TRUE,fac.out = 1.0, pal = blue2green2red(101),
                          aspect=2)
#built 2D morphometric map with GAM smoothing
bone2Dmap<-morphomap2Dmap(morphomap.shape=shapeSections,gam=TRUE,
                          plot = TRUE, rem.out = TRUE,fac.out = 1.0, pal = blue2green2red(101),
                          aspect=2)

#morphomap on a chimpanzee femur bone
data(PanFem27713)
meshes<-morphomapSegm(PanFem27713, param1=3)
perMesh<-meshes$external
endMesh<-meshes$internal
mech_length<-277.13
rawSections<-morphomapCore(out.sur=perMesh,
                           inn.sur=endMesh,num.sect=61,mech.len = mech_length, start = 0.2,end=0.8)
shapeSections<-morphomapShape(rawSections,24,sects_vector=NULL,cent.out="CCA",
delta=0.1, side="left")
#built 2D morphometric map without GAM smoothing
bone2Dmap<-morphomap2Dmap(morphomap.shape=shapeSections,plot = TRUE, 
rem.out = TRUE,fac.out = 1.0,pal = blue2green2red(101),aspect=2)
#built 2D morphometric map with GAM smoothing
bone2Dmap<-morphomap2Dmap(morphomap.shape=shapeSections,gam=TRUE,
                          plot = TRUE, rem.out = TRUE,fac.out = 1.0,pal = blue2green2red(101),
                          aspect=2)
}
}
\author{
Antonio Profico, Luca Bondioli, Pasquale Raia, Paul O'Higgins, Damiano Marchi
}
