% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokenize.R
\name{.mp_tokenize_word_bidir}
\alias{.mp_tokenize_word_bidir}
\title{Tokenize a Word Bidirectionally}
\usage{
.mp_tokenize_word_bidir(
  word,
  vocab,
  unk_token,
  max_chars,
  allow_compounds = TRUE
)
}
\arguments{
\item{word}{Character scalar; word to tokenize.}

\item{vocab}{Named integer vector containing vocabulary words. Should have
"vocab_split" attribute, with components named "prefixes", "words",
"suffixes".}

\item{unk_token}{Token to represent unknown words.}

\item{max_chars}{Maximum length of word recognized.}

\item{allow_compounds}{Logical; whether to allow multiple whole words in the
breakdown. Default is TRUE. This option will not be exposed to end users;
it is kept here for documentation + development purposes.}
}
\value{
Input word as a list of tokens.
}
\description{
Apply .mp_tokenize_word from both directions and pick the result with fewer
pieces.
}
\keyword{internal}
