% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/object.R
\name{mongo}
\alias{mongo}
\title{MongoDB client}
\usage{
mongo(collection = "test", db = "test", url = "mongodb://localhost")
}
\arguments{
\item{collection}{name of collection}

\item{db}{name of database}

\item{url}{address of the mongodb server}
}
\value{
Upon success returns a pointer to a collection on the server.
The collection can be interfaced using the methods described below.
}
\description{
Connect to a MongoDB collection.
}
\section{Methods}{

\describe{
  \item{\code{aggregate(pipeline = '{}', handler = NULL, pagesize = 1000, verbose = TRUE)}}{Execute a pipeline using the Mongo aggregation framework.}
  \item{\code{count(query = '{}')}}{Count the number of records matching a given \code{query}. Default counts all records in collection.}
  \item{\code{drop()}}{Delete entire collection with all data and metadata.}
  \item{\code{find(query = '{}', fields = '{"_id" : 0}', skip = 0, limit = 0, handler = NULL, pagesize = 1000, verbose = TRUE)}}{Retrieve \code{fields} from records matching \code{query}. Default \code{handler} will return all data as a single dataframe.}
  \item{\code{index(add = NULL, remove = NULL)}}{List, add, or remove indexes from the collection. Returns a dataframe with current indexes.}
  \item{\code{info()}}{Returns collection statistics and server info (if available).}
  \item{\code{insert(data, pagesize = 1000, verbose = TRUE)}}{Insert a dataframe into the collection.}
  \item{\code{remove(query = "{}", multiple = FALSE)}}{Remove record(s) matching \code{query} from the collection.}
  \item{\code{rename(name, db = "test")}}{Change the name or database of a collection. Changing name is cheap, changing database is expensive.}
  \item{\code{update(query, update = '{"$set":{}}', upsert = FALSE, multiple = FALSE)}}{Replace or modify matching record(s) with value of the \code{update} argument.}
}
}
\examples{
\dontrun{
# dplyr example
library(nycflights13)

# Insert some data
m <- mongo(collection = "nycflights")
m$drop()
m$insert(flights)

# Basic queries
m$count('{"month":1, "day":1}')
jan1 <- m$find('{"month":1, "day":1}')

# Sorting
jan1 <- m$find('{"$query":{"month":1,"day":1}, "$orderby":{"distance":-1}}')
head(jan1)

# Select columns
jan1 <- m$find('{"month":1,"day":1}', fields = '{"_id":0, "distance":1, "carrier":1}')

# Tabulate
m$aggregate('[{"$group":{"_id":"$carrier", "count": {"$sum":1}, "average":{"$avg":"$distance"}}}]')
}
}
\references{
Jeroen Ooms (2014). The \code{jsonlite} Package: A Practical and Consistent Mapping Between JSON Data and \R{} Objects. \emph{arXiv:1403.2805}. \url{http://arxiv.org/abs/1403.2805}
}

