% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qmoezipf.R
\name{qmoezipf}
\alias{qmoezipf}
\title{Quantile function of the distribution.}
\usage{
qmoezipf(p, alpha, beta)
}
\arguments{
\item{p}{Vector of probabilities.}

\item{alpha}{Value of the \eqn{\alpha} parameter (\eqn{\alpha} > 1).}

\item{beta}{Value of the \eqn{\beta} parameter (\eqn{\beta} > 0).}
}
\value{
Quantiles associated to a given probability vector \code{p}.
}
\description{
Computes the inverse cumulative function for a given vector of probabilities p.
It requires the \code{\link{qzipfman}} function implemented into the
\code{\link{tolerance}} package refered below.
}
\details{
The calculus of the quantiles of a MOEZipf distribution for a given probability
vector \code{p}, is obtained by computing the quartiles of a Zipf distribution with
the same parameter \eqn{\alpha}, and probability vector equal to:

\deqn{p\prime = \frac{p \beta}{1 + p(\beta - 1)}}
}
\examples{
qmoezipf(0.56, 2.5, 1.3)
}
\references{
{ Young, D. S. (2010). \emph{Tolerance: an R package for estimating tolerance intervals}. Journal of Statistical Software, 36(5), 1-39.
 \url{https://core.ac.uk/download/pdf/6340270.pdf?repositoryId=153}}
}

