% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moezipfR.log.density.R
\name{moezipfR.log.density}
\alias{moezipfR.log.density}
\title{Log density function.}
\usage{
moezipfR.log.density(x, alpha, beta, show.plot = F)
}
\arguments{
\item{x}{Vector of positive integer values.}

\item{alpha}{Value of the \eqn{\alpha} parameter (\eqn{\alpha > 1}).}

\item{beta}{Value of the \eqn{\beta} parameter (\eqn{\beta > 0}).}

\item{show.plot}{logical; if TRUE shows the plot of the distibution (default = FALSE).}
}
\value{
The log of the probability associated to each value in vector \code{x}.
}
\description{
Computes the log of the probability mass function of the MOEZipf distribution.
}
\examples{
moezipfR.log.density(1:10, 2.5, 1.3)
moezipfR.log.density(1:10, 2.5, 1.3, show.plot = TRUE)
}

