% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modsem_da.R
\name{modsem_da}
\alias{modsem_da}
\title{Interaction between latent variables using lms and qml approaches}
\usage{
modsem_da(
  model.syntax = NULL,
  data = NULL,
  method = "lms",
  verbose = NULL,
  optimize = NULL,
  nodes = NULL,
  convergence = NULL,
  optimizer = NULL,
  center.data = NULL,
  standardize.data = NULL,
  standardize.out = NULL,
  standardize = NULL,
  mean.observed = NULL,
  cov.syntax = NULL,
  double = NULL,
  calc.se = NULL,
  FIM = NULL,
  EFIM.S = NULL,
  OFIM.hessian = NULL,
  EFIM.parametric = NULL,
  robust.se = NULL,
  R.max = NULL,
  max.iter = NULL,
  max.step = NULL,
  fix.estep = NULL,
  start = NULL,
  epsilon = NULL,
  quad.range = NULL,
  n.threads = NULL,
  ...
)
}
\arguments{
\item{model.syntax}{\code{lavaan} syntax}

\item{data}{dataframe}

\item{method}{method to use:
\code{"lms"} = latent model structural equations (not passed to \code{lavaan}).
\code{"qml"} = quasi maximum likelihood estimation of latent model structural equations (not passed to \code{lavaan}).}

\item{verbose}{should estimation progress be shown}

\item{optimize}{should starting parameters be optimized}

\item{nodes}{number of quadrature nodes (points of integration) used in \code{lms},
increased number gives better estimates but slower computation. How many are needed depends on the complexity of the model.
For simple models, somewhere between 16-24 nodes should be enough; for more complex models, higher numbers may be needed.
For models where there is an interaction effect between an endogenous and exogenous variable,
the number of nodes should be at least 32, but practically (e.g., ordinal/skewed data), more than 32 is recommended. In cases
where data is non-normal, it might be better to use the \code{qml} approach instead. For large
numbers of nodes, you might want to change the \code{'quad.range'} argument.}

\item{convergence}{convergence criterion. Lower values give better estimates but slower computation.}

\item{optimizer}{optimizer to use, can be either \code{"nlminb"} or \code{"L-BFGS-B"}. For LMS, \code{"nlminb"} is recommended.
For QML, \code{"L-BFGS-B"} may be faster if there is a large number of iterations, but slower if there are few iterations.}

\item{center.data}{should data be centered before fitting model}

\item{standardize.data}{should data be scaled before fitting model, will be overridden by
\code{standardize} if \code{standardize} is set to \code{TRUE}.

\strong{NOTE}: It is recommended that you estimate the model normally and then standardize the output using
\code{\link{standardized_estimates}}.}

\item{standardize.out}{should output be standardized (note will alter the relationships of
parameter constraints since parameters are scaled unevenly, even if they
have the same label). This does not alter the estimation of the model, only the
output.

\strong{NOTE}: It is recommended that you estimate the model normally and then standardize the output using
\code{\link{standardized_estimates}}.}

\item{standardize}{will standardize the data before fitting the model, remove the mean
structure of the observed variables, and standardize the output. Note that \code{standardize.data},
\code{mean.observed}, and \code{standardize.out} will be overridden by \code{standardize} if \code{standardize} is set to \code{TRUE}.

\strong{NOTE}: It is recommended that you estimate the model normally and then standardize the output using
\code{\link{standardized_estimates}}.}

\item{mean.observed}{should the mean structure of the observed variables be estimated?
This will be overridden by \code{standardize} if \code{standardize} is set to \code{TRUE}.

\strong{NOTE}: Not recommended unless you know what you are doing.}

\item{cov.syntax}{model syntax for implied covariance matrix (see \code{vignette("interaction_two_etas", "modsem")})}

\item{double}{try to double the number of dimensions of integration used in LMS,
this will be extremely slow but should be more similar to \code{mplus}.}

\item{calc.se}{should standard errors be computed? \strong{NOTE}: If \code{FALSE}, the information matrix will not be computed either.}

\item{FIM}{should the Fisher information matrix be calculated using the observed or expected values? Must be either \code{"observed"} or \code{"expected"}.}

\item{EFIM.S}{if the expected Fisher information matrix is computed, \code{EFIM.S} selects the number of Monte Carlo samples. Defaults to 100. 
\strong{NOTE}: This number should likely be increased for better estimates (e.g., 1000-10000), but it might drasticly increase computation time.}

\item{OFIM.hessian}{should the observed Fisher information be computed using the Hessian? If \code{FALSE}, it is computed using the gradient.}

\item{EFIM.parametric}{should data for calculating the expected Fisher information matrix be
simulated parametrically (simulated based on the assumptions and implied parameters
from the model), or non-parametrically (stochastically sampled)? If you believe that
normality assumptions are violated, \code{EFIM.parametric = FALSE} might be the better option.}

\item{robust.se}{should robust standard errors be computed? Meant to be used for QML,
can be unreliable with the LMS approach.}

\item{R.max}{Maximum population size (not sample size) used in the calculated of the expected
fischer information matrix.}

\item{max.iter}{maximum number of iterations.}

\item{max.step}{maximum steps for the M-step in the EM algorithm (LMS).}

\item{fix.estep}{if \code{TRUE}, the E-step will be fixed, and the prior probabilities will be set to the best prior probabilities,
if the log-likelihood decreases for more than 30 iterations.}

\item{start}{starting parameters.}

\item{epsilon}{finite difference for numerical derivatives.}

\item{quad.range}{range in z-scores to perform numerical integration in LMS using
Gaussian-Hermite Quadratures. By default \code{Inf}, such that \code{f(t)} is integrated from -Inf to Inf,
but this will likely be inefficient and pointless at a large number of nodes. Nodes outside
\code{+/- quad.range} will be ignored.}

\item{n.threads}{number of cores to use for parallel processing. If \code{NULL}, it will use <= 2 threads.
If an integer is specified, it will use that number of threads (e.g., \code{n.threads = 4} will use 4 threads).
If \code{"default"}, it will use the default number of threads (2).
If \code{"max"}, it will use all available threads, \code{"min"} will use 1 thread.}

\item{...}{additional arguments to be passed to the estimation function.}
}
\value{
\code{modsem_da} object
}
\description{
\code{modsem_da()} is a function for estimating interaction effects between latent variables
in structural equation models (SEMs) using distributional analytic (DA) approaches.
Methods for estimating interaction effects in SEMs can basically be split into
two frameworks:
1. Product Indicator-based approaches (\code{"dblcent"}, \code{"rca"}, \code{"uca"},
\code{"ca"}, \code{"pind"})
2. Distributionally based approaches (\code{"lms"}, \code{"qml"}).

\code{modsem_da()} handles the latter and can estimate models using both QML and LMS,
necessary syntax, and variables for the estimation of models with latent product indicators.

\strong{NOTE}: Run \code{\link{default_settings_da}} to see default arguments.
}
\examples{
library(modsem)
# For more examples, check README and/or GitHub.
# One interaction
m1 <- "
  # Outer Model
  X =~ x1 + x2 +x3
  Y =~ y1 + y2 + y3
  Z =~ z1 + z2 + z3

  # Inner model
  Y ~ X + Z + X:Z
"

\dontrun{
# QML Approach
est1 <- modsem_da(m1, oneInt, method = "qml")
summary(est1)

# Theory Of Planned Behavior
tpb <- "
# Outer Model (Based on Hagger et al., 2007)
  ATT =~ att1 + att2 + att3 + att4 + att5
  SN =~ sn1 + sn2
  PBC =~ pbc1 + pbc2 + pbc3
  INT =~ int1 + int2 + int3
  BEH =~ b1 + b2

# Inner Model (Based on Steinmetz et al., 2011)
  # Covariances
  ATT ~~ SN + PBC
  PBC ~~ SN
  # Causal Relationships
  INT ~ ATT + SN + PBC
  BEH ~ INT + PBC
  BEH ~ INT:PBC
"

# LMS Approach
estTpb <- modsem_da(tpb, data = TPB, method = lms, EFIM.S = 1000)
summary(estTpb)
}
}
