% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modsem_pi.R
\name{modsem_pi}
\alias{modsem_pi}
\title{Interaction between latent variables using product indicators}
\usage{
modsem_pi(
  model.syntax = NULL,
  data = NULL,
  method = "dblcent",
  match = NULL,
  standardize.data = FALSE,
  center.data = FALSE,
  first.loading.fixed = TRUE,
  center.before = NULL,
  center.after = NULL,
  residuals.prods = NULL,
  residual.cov.syntax = NULL,
  constrained.prod.mean = NULL,
  constrained.loadings = NULL,
  constrained.var = NULL,
  constrained.res.cov.method = NULL,
  auto.scale = "none",
  auto.center = "none",
  estimator = "ML",
  group = NULL,
  run = TRUE,
  suppress.warnings.lavaan = FALSE,
  ...
)
}
\arguments{
\item{model.syntax}{\code{lavaan} syntax}

\item{data}{dataframe}

\item{method}{method to use:
\code{"rca"} = residual centering approach (passed to \code{lavaan}),
\code{"uca"} = unconstrained approach (passed to \code{lavaan}),
\code{"dblcent"} = double centering approach (passed to \code{lavaan}),
\code{"pind"} = prod ind approach, with no constraints or centering (passed to \code{lavaan}),
\code{"custom"} = use parameters specified in the function call (passed to \code{lavaan})}

\item{match}{should the product indicators be created by using the match-strategy}

\item{standardize.data}{should data be scaled before fitting model}

\item{center.data}{should data be centered before fitting model}

\item{first.loading.fixed}{Should the first factor loading in the latent product be fixed to one?}

\item{center.before}{should indicators in products be centered before computing products (overwritten by \code{method}, if \code{method != NULL})}

\item{center.after}{should indicator products be centered after they have been computed?}

\item{residuals.prods}{should indicator products be centered using residuals (overwritten by \code{method}, if \code{method != NULL})}

\item{residual.cov.syntax}{should syntax for residual covariances be produced (overwritten by \code{method}, if \code{method != NULL})}

\item{constrained.prod.mean}{should syntax for product mean be produced (overwritten by \code{method}, if \code{method != NULL})}

\item{constrained.loadings}{should syntax for constrained loadings be produced (overwritten by \code{method}, if \code{method != NULL})}

\item{constrained.var}{should syntax for constrained variances be produced (overwritten by \code{method}, if \code{method != NULL})}

\item{constrained.res.cov.method}{method for constraining residual covariances}

\item{auto.scale}{methods which should be scaled automatically (usually not useful)}

\item{auto.center}{methods which should be centered automatically (usually not useful)}

\item{estimator}{estimator to use in \code{lavaan}}

\item{group}{group variable for multigroup analysis}

\item{run}{should the model be run via \code{lavaan}, if \code{FALSE} only modified syntax and data is returned}

\item{suppress.warnings.lavaan}{should warnings from \code{lavaan} be suppressed?}

\item{...}{arguments passed to other functions, e.g., \code{lavaan}}
}
\value{
\code{modsem} object
}
\description{
\code{modsem_pi()} is a function for estimating interaction effects between latent variables, 
in structural equation models (SEMs), using product indicators.
Methods for estimating interaction effects in SEMs can basically be split into 
two frameworks: 
1. Product Indicator based approaches (\code{"dblcent"}, \code{"rca"}, \code{"uca"}, 
\code{"ca"}, \code{"pind"}), and 
2. Distributionally based approaches (\code{"lms"}, \code{"qml"}).
\code{modsem_pi()} is essentially a fancy wrapper for \code{lavaan::sem()} which generates the 
necessary syntax and variables for the estimation of models with latent product indicators.
Use \code{default_settings_pi()} to get the default settings for the different methods.
}
\examples{
library(modsem)
# For more examples, check README and/or GitHub.
# One interaction
m1 <- '
  # Outer Model
  X =~ x1 + x2 +x3
  Y =~ y1 + y2 + y3
  Z =~ z1 + z2 + z3
  
  # Inner model
  Y ~ X + Z + X:Z 
'

# Double centering approach
est1 <- modsem_pi(m1, oneInt)
summary(est1)

\dontrun{
# The Constrained Approach 
est1Constrained <- modsem_pi(m1, oneInt, method = "ca")
summary(est1Constrained)
}

# Theory Of Planned Behavior
tpb <- ' 
# Outer Model (Based on Hagger et al., 2007)
  ATT =~ att1 + att2 + att3 + att4 + att5
  SN =~ sn1 + sn2
  PBC =~ pbc1 + pbc2 + pbc3
  INT =~ int1 + int2 + int3
  BEH =~ b1 + b2

# Inner Model (Based on Steinmetz et al., 2011)
  # Covariances
  ATT ~~ SN + PBC
  PBC ~~ SN 
  # Causal Relationships
  INT ~ ATT + SN + PBC
  BEH ~ INT + PBC 
  BEH ~ INT:PBC  
'

# Double centering approach
estTpb <- modsem_pi(tpb, data = TPB)
summary(estTpb)

\dontrun{
# The Constrained Approach 
estTpbConstrained <- modsem_pi(tpb, data = TPB, method = "ca")
summary(estTpbConstrained)
}
}
