% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/generics_lavaan.R,
%   R/generics_modsem_da.R, R/generics_modsem_pi.R
\name{modsem_inspect}
\alias{modsem_inspect}
\alias{modsem_inspect.lavaan}
\alias{modsem_inspect.modsem_da}
\alias{modsem_inspect.modsem_pi}
\title{Inspect model information}
\usage{
modsem_inspect(object, what = NULL, ...)

\method{modsem_inspect}{lavaan}(object, what = "free", ...)

\method{modsem_inspect}{modsem_da}(object, what = NULL, ...)

\method{modsem_inspect}{modsem_pi}(object, what = "free", ...)
}
\arguments{
\item{object}{A fitted object of class \code{"modsem_da"}.}

\item{what}{Character scalar selecting what to return (see \emph{Details}).
If \code{NULL} the value \code{"default"} is used.}

\item{...}{Passed straight to \code{modsem_inspect_da()}.}
}
\value{
A named list with the extracted information. If a single piece of information is returned,
 it is returned as is; not as a named element in a list.
}
\description{
function used to inspect fitted object. Similar to \code{lavaan::lavInspect}
argument \code{what} decides what to inspect

\code{modsem_inspect.modsem_da} Lets you
pull matrices, optimiser diagnostics, expected moments, or fit
measures from a \code{\link{modsem_da}} object.
}
\details{
For \code{\link{modsem_pi}} objects, it is just a wrapper for \code{lavaan::lavInspect}.
 For \code{\link{modsem_da}} objects an internal function is called, which takes different
 keywords for the \code{what} argument.

Below is a list of possible values for the \code{what} argument,
organised in several sections.  Keywords are \emph{case-sensitive}.

\strong{Presets}

\describe{
  \item{\code{"default"}}{Everything in \emph{Sample information}, \emph{Optimiser diagnostics}
  \emph{Parameter tables}, \emph{Model matrices}, and \emph{Expected-moment matrices} except
  the raw \code{data} slot}
  \item{\code{"coef"}}{Coefficients and variance-covariance matrix of both free and constrained parameters (same as \code{"coef.all"}).}
  \item{\code{"coef.all"}}{Coefficients and variance-covariance matrix of both free and constrained parameters (same as \code{"coef"}).}
  \item{\code{"coef.free"}}{Coefficients and variance-covariance matrix of the free parameters.}
  \item{\code{"all"}}{All items listed below, including \code{data}.}
  \item{\code{"matrices"}}{The model matrices.}
  \item{\code{"optim"}}{Only the items under \emph{Optimiser diagnostics}}.
  \item{\code{"fit"}}{A list with \code{fit.h0}, \code{fit.h1}, comparative.fit}
}

\strong{Sample information:}

\describe{
\item{\code{"N"}}{Number of analysed rows (integer).}
}

\strong{Parameter estimates and standard errors:}

\describe{
  \item{\code{"coefficients.free"}}{Free parameter values.}
  \item{\code{"coefficients.all"}}{Both free and constrained parameter values.}
  \item{\code{"vcov.free"}}{Variance–covariance of free coefficients only.}
  \item{\code{"vcov.all"}}{Variance–covariance of both free and constrained coefficients.}
}

\strong{Optimiser diagnostics:}

\describe{
  \item{\code{"coefficients.free"}}{Free parameter values.}
  \item{\code{"vcov.free"}}{Variance–covariance of free coefficients only.}
  \item{\code{"information"}}{Fisher information matrix.}
  \item{\code{"loglik"}}{Log-likelihood.}
  \item{\code{"iterations"}}{Optimiser iteration count.}
  \item{\code{"convergence"}}{\code{TRUE}/\code{FALSE} indicating whether the model converged.}
}

\strong{Parameter tables:}

\describe{
  \item{\code{"partable"}}{Parameter table with estimated parameters.}
  \item{\code{"partable.input"}}{Parsed model syntax.}
}

\strong{Model matrices:}

\describe{
  \item{\code{"lambda"}}{\eqn{\Lambda} – Factor loadings.}
  \item{\code{"tau"}}{\eqn{\tau} – Intercepts for indicators.}
  \item{\code{"theta"}}{\eqn{\Theta} – Residual (Co-)Variances for indicators.}
  \item{\code{"gamma.xi"}}{\eqn{\Gamma_{\xi}} – Structural coefficients between exogenous and endogenous variables.}
  \item{\code{"gamma.eta"}}{\eqn{\Gamma_{\eta}} – Structural coefficients between endogenous variables.}
  \item{\code{"omega.xi.xi"}}{\eqn{\Omega_{\xi\xi}} – Interaction effects between exogenous variables}
  \item{\code{"omega.eta.xi"}}{\eqn{\Omega_{\eta\xi}} – Interaction effects between exogenous and endogenous variables}
  \item{\code{"phi"}}{\eqn{\Phi} – (Co-)Variances among exogenous variables.}
  \item{\code{"psi"}}{\eqn{\Psi} – Residual (co-)variances among engoenous variables.}
  \item{\code{"alpha"}}{\eqn{\alpha} – Intercepts for endogenous variables}
  \item{\code{"beta0"}}{\eqn{\beta_0} – Intercepts for exogenous variables}
}
\strong{Model-implied matrices:}

\describe{
  \item{\code{"cov.ov"}}{Model-implied covariance of observed variables.}
  \item{\code{"cov.lv"}}{Model-implied covariance of latent variables.}
  \item{\code{"cov.all"}}{Joint covariance of observed + latent variables.}
  \item{\code{"cor.ov"}}{Correlation counterpart of \code{"cov.ov"}.}
  \item{\code{"cor.lv"}}{Correlation counterpart of \code{"cov.lv"}.}
  \item{\code{"cor.all"}}{Correlation counterpart of \code{"cov.all"}.}
  \item{\code{"mean.ov"}}{Expected means of observed variables.}
  \item{\code{"mean.lv"}}{Expected means of latent variables.}
  \item{\code{"mean.all"}}{Joint mean vector.}
}

\strong{R-squared and standardized residual variances:}

\describe{
  \item{\code{"r2.all"}}{R-squared values for both observed (i.e., indicators) and latent endogenous variables.}
  \item{\code{"r2.lv"}}{R-squared values for latent endogenous variables.}
  \item{\code{"r2.ov"}}{R-squared values for observed (i.e., indicators) variables.}
  \item{\code{"res.all"}}{Standardized residuals (i.e., \code{1 - R^2}) for both observed (i.e., indicators) and latent endogenous variables.}
  \item{\code{"res.lv"}}{Standardized residuals (i.e., \code{1 - R^2}) for latent endogenous variables.}
  \item{\code{"res.ov"}}{Standardized residuals (i.e., \code{1 - R^2}) for observed variables (i.e., indicators).}
}

\strong{Interaction-specific caveats:}

\itemize{
  \item If the model contains an \emph{uncentred} latent interaction term it is centred
    internally before any \code{cov.*}, \code{cor.*}, or \code{mean.*} matrices are
    calculated.
  \item These matrices should not be used to compute fit-statistics (e.g.,
    chi-square and RMSEA) if there is an interaction term in the model.
}
}
\section{Methods (by class)}{
\itemize{
\item \code{modsem_inspect(lavaan)}: Inspect a \code{lavaan} object

\item \code{modsem_inspect(modsem_da)}: Inspect a \code{\link{modsem_da}} object

\item \code{modsem_inspect(modsem_pi)}: Inspect a \code{\link{modsem_pi}} object

}}
\examples{
\dontrun{
m1 <- "
 # Outer Model
 X =~ x1 + x2 + x3
 Y =~ y1 + y2 + y3
 Z =~ z1 + z2 + z3

 # Inner model
 Y ~ X + Z + X:Z
"

est <- modsem(m1, oneInt, "lms")

modsem_inspect(est) # everything except "data"
modsem_inspect(est, what = "optim")
modsem_inspect(est, what = "phi")
}

}
