% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMD.R
\name{PlotMD}
\alias{PlotMD}
\title{QQ-Plot of Mahalanobis distances}
\usage{
PlotMD(dist, p, alpha = 0.95, chisquare = FALSE)
}
\arguments{
\item{dist}{a vector of Mahalanobis distances.}

\item{p}{the number of variables involved in the Mahalanobis distances.}

\item{alpha}{a probability for cut-off, usually close to 1.}

\item{chisquare}{a logical indicating the the chisquare distribution should be used instead of the F-distribution.}
}
\value{
\item{hmed}{first proposed cutpoint based on F-distribution}

\item{halpha}{second proposed cutpoint (alpha-quantile)}

\item{QQ-plot}{}
}
\description{
QQ-plot of (squared) Mahalanobis distances vs. scaled F-distribution (or a scaled chisquare distribution).
In addition, two default cutpoints are proposed.
}
\details{
Scaling of the F-distribution as \code{median(dist)*qf((1:n)/(n+1), p, n-p)/qf(0.5, p, n-p)}.
First default cutpoint is \code{median(dist)*qf(alpha, p, n-p)/qf(0.5, p, n-p)} and the second default
cutpoint is the alpha quantile of the Mahalanobis distances.
}
\examples{
data(bushfirem, bushfire.weights)
det.res <- TRC(bushfirem, weights = bushfire.weights)
PlotMD(det.res$dist, ncol(bushfirem))
}
\references{
Little, R. & Smith, P. (1987) Editing and imputation for quantitative survey data,
Journal of the American Statistical Association, 82, 58-68
}
\author{
Beat Hulliger
}
