% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeltime-residuals-plot.R
\name{plot_modeltime_residuals}
\alias{plot_modeltime_residuals}
\title{Interactive Residuals Visualization}
\usage{
plot_modeltime_residuals(
  .data,
  .type = c("timeplot", "acf", "seasonality"),
  .smooth = FALSE,
  .legend_show = TRUE,
  .legend_max_width = 40,
  .title = "Residuals Plot",
  .x_lab = "",
  .y_lab = "",
  .color_lab = "Legend",
  .interactive = TRUE,
  ...
)
}
\arguments{
\item{.data}{A \code{tibble} that is the output of \code{\link[=modeltime_residuals]{modeltime_residuals()}}}

\item{.type}{One of "timeplot", "acf", or "seasonality". The default is "timeplot".}

\item{.smooth}{Logical - Whether or not to include a trendline smoother.
Uses See \code{\link[timetk:smooth_vec]{smooth_vec()}} to apply a LOESS smoother.}

\item{.legend_show}{Logical. Whether or not to show the legend.
Can save space with long model descriptions.}

\item{.legend_max_width}{Numeric. The width of truncation to apply to the legend text.}

\item{.title}{Title for the plot}

\item{.x_lab}{X-axis label for the plot}

\item{.y_lab}{Y-axis label for the plot}

\item{.color_lab}{Legend label if a \code{color_var} is used.}

\item{.interactive}{Returns either a static (\code{ggplot2}) visualization or an interactive (\code{plotly}) visualization}

\item{...}{Additional arguments passed to:
\itemize{
\item Time Plot: \code{\link[=plot_time_series]{plot_time_series()}}
\item ACF Plot: \code{\link[=plot_acf_diagnostics]{plot_acf_diagnostics()}}
\item Seasonality Plot: \code{\link[=plot_seasonal_diagnostics]{plot_seasonal_diagnostics()}}
}}
}
\value{
A static \code{ggplot2} plot or an interactive \code{plotly} plot containing residuals vs time
}
\description{
This is a wrapper for examining residuals using:
\itemize{
\item Time Plot: \code{\link[=plot_time_series]{plot_time_series()}}
\item ACF Plot: \code{\link[=plot_acf_diagnostics]{plot_acf_diagnostics()}}
\item Seasonality Plot: \code{\link[=plot_seasonal_diagnostics]{plot_seasonal_diagnostics()}}
}
}
\examples{
library(tidyverse)
library(lubridate)
library(timetk)
library(parsnip)
library(rsample)
library(modeltime)

# Data
m750 <- m4_monthly \%>\% filter(id == "M750")

# Split Data 80/20
splits <- initial_time_split(m750, prop = 0.9)

# --- MODELS ---

# Model 1: prophet ----
model_fit_prophet <- prophet_reg() \%>\%
    set_engine(engine = "prophet") \%>\%
    fit(value ~ date, data = training(splits))


# ---- MODELTIME TABLE ----

models_tbl <- modeltime_table(
    model_fit_prophet
)

# ---- RESIDUALS ----

residuals_tbl <- models_tbl \%>\%
    modeltime_calibrate(new_data = testing(splits)) \%>\%
    modeltime_residuals()

residuals_tbl \%>\%
    plot_modeltime_residuals(
        .type = "timeplot",
        .interactive = FALSE
    )

}
