% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsnip-prophet_reg.R
\name{prophet_reg}
\alias{prophet_reg}
\title{General Interface for PROPHET Time Series Models}
\usage{
prophet_reg(
  mode = "regression",
  growth = NULL,
  num_changepoints = NULL,
  season = NULL,
  prior_scale_changepoints = NULL,
  prior_scale_seasonality = NULL,
  prior_scale_holidays = NULL
)
}
\arguments{
\item{mode}{A single character string for the type of model.
The only possible value for this model is "regression".}

\item{growth}{String 'linear' or 'logistic' to specify a linear or logistic trend.}

\item{num_changepoints}{Number of potential changepoints to include for modeling trend.}

\item{season}{'additive' (default) or 'multiplicative'.}

\item{prior_scale_changepoints}{Parameter modulating the flexibility of the
automatic changepoint selection. Large values will allow many changepoints,
small values will allow few changepoints.}

\item{prior_scale_seasonality}{Parameter modulating the strength of the
seasonality model. Larger values allow the model to fit larger seasonal
fluctuations, smaller values dampen the seasonality.}

\item{prior_scale_holidays}{Parameter modulating the strength of the holiday components model,
unless overridden in the holidays input.}
}
\description{
\code{prophet_reg()} is a way to generate a \emph{specification} of a PROPHET model
before fitting and allows the model to be created using
different packages. Currently the only package is \code{prophet}.
}
\details{
The data given to the function are not saved and are only used
to determine the \emph{mode} of the model. For \code{prophet_reg()}, the
mode will always be "regression".

The model can be created using the \code{fit()} function using the
following \emph{engines}:
\itemize{
\item "prophet" (default) - Connects to \code{\link[prophet:prophet]{prophet::prophet()}}
}

\strong{Main Arguments}

The main arguments (tuning parameters) for the model are:
\itemize{
\item \code{growth}: String 'linear' or 'logistic' to specify a linear or logistic trend.
\item \code{num_changepoints}: Number of potential changepoints to include for modeling trend.
\item \code{season}: 'additive' (default) or 'multiplicative'.
\item \code{prior_scale_changepoints}: Parameter modulating the flexibility of the
automatic changepoint selection. Large values will allow many changepoints,
small values will allow few changepoints.
\item \code{prior_scale_seasonality}: Parameter modulating the strength of the
seasonality model. Larger values allow the model to fit larger seasonal
fluctuations, smaller values dampen the seasonality.
\item \code{prior_scale_holidays}: Parameter modulating the strength of the holiday components model,
unless overridden in the holidays input.
}

These arguments are converted to their specific names at the
time that the model is fit.

Other options and argument can be
set using \code{set_engine()} (See Engine Details below).

If parameters need to be modified, \code{update()} can be used
in lieu of recreating the object from scratch.
}
\section{Engine Details}{


The standardized parameter names in \code{modeltime} can be mapped to their original
names in each engine:\tabular{ll}{
   modeltime \tab prophet \cr
   growth \tab growth \cr
   num_changepoints \tab n.changepoints \cr
   season \tab seasonality.mode \cr
   prior_scale_changepoints \tab changepoint.prior.scale \cr
   prior_scale_seasonality \tab seasonality.prior.scale \cr
   prior_scale_holidays \tab holidays.prior.scale \cr
}


Other options can be set using \code{set_engine()}.

\strong{prophet}

The engine uses \code{\link[prophet:prophet]{prophet::prophet()}}.

Function Parameters:\preformatted{## function (df = NULL, growth = "linear", changepoints = NULL, n.changepoints = 25, 
##     changepoint.range = 0.8, yearly.seasonality = "auto", weekly.seasonality = "auto", 
##     daily.seasonality = "auto", holidays = NULL, seasonality.mode = "additive", 
##     seasonality.prior.scale = 10, holidays.prior.scale = 10, changepoint.prior.scale = 0.05, 
##     mcmc.samples = 0, interval.width = 0.8, uncertainty.samples = 1000, 
##     fit = TRUE, ...)
}

Parameter Notes:
\itemize{
\item \code{df}: This is supplied via the parsnip / modeltime \code{fit()} interface
(so don't provide this manually). See Fit Details (below).
\item \code{holidays}: A data.frame of holidays can be supplied via \code{set_engine()}
\item \code{uncertainty.samples}: The default is set to 0 because the prophet
uncertainty intervals are not used as part of the Modeltime Workflow.
You can override this setting if you plan to use prophet's uncertainty tools.
}

Limitations:
\itemize{
\item \code{prophet::add_seasonality()} is not currently implemented. It's used to
specify non-standard seasonalities using fourier series. An alternative is to use
\code{step_fourier()} and supply custom seasonalities as Extra Regressors.
}
}

\section{Fit Details}{


\strong{Date and Date-Time Variable}

It's a requirement to have a date or date-time variable as a predictor.
The \code{fit()} interface accepts date and date-time features and handles them internally.
\itemize{
\item \code{fit(y ~ date)}
}

\strong{Univariate (No Extra Regressors):}

For univariate analysis, you must include a date or date-time feature. Simply use:
\itemize{
\item Formula Interface (recommended): \code{fit(y ~ date)} will ignore xreg's.
\item XY Interface: \code{fit_xy(x = data[,"date"], y = data$y)} will ignore xreg's.
}

\strong{Multivariate (Extra Regressors)}

Extra Regressors parameter is populated using the \code{fit()} or \code{fit_xy()} function:
\itemize{
\item Only \code{factor}, \verb{ordered factor}, and \code{numeric} data will be used as xregs.
\item Date and Date-time variables are not used as xregs
\item \code{character} data should be converted to factor.
}

\emph{Xreg Example:} Suppose you have 3 features:
\enumerate{
\item \code{y} (target)
\item \code{date} (time stamp),
\item \code{month.lbl} (labeled month as a ordered factor).
}

The \code{month.lbl} is an exogenous regressor that can be passed to the \code{arima_reg()} using
\code{fit()}:
\itemize{
\item \code{fit(y ~ date + month.lbl)} will pass \code{month.lbl} on as an exogenous regressor.
\item \code{fit_xy(data[,c("date", "month.lbl")], y = data$y)} will pass x, where x is a data frame containing \code{month.lbl}
and the \code{date} feature. Only \code{month.lbl} will be used as an exogenous regressor.
}

Note that date or date-time class values are excluded from \code{xreg}.
}

\examples{
library(dplyr)
library(parsnip)
library(rsample)
library(timetk)
library(modeltime)

# Data
m750 <- m4_monthly \%>\% filter(id == "M750")
m750

# Split Data 80/20
splits <- initial_time_split(m750, prop = 0.8)

# ---- PROPHET ----

# Model Spec
model_spec <- prophet_reg() \%>\%
    set_engine("prophet")

# Fit Spec
model_fit <- model_spec \%>\%
    fit(log(value) ~ date, data = training(splits))
model_fit



}
\seealso{
\code{\link[=fit.model_spec]{fit.model_spec()}}, \code{\link[=set_engine]{set_engine()}}
}
