% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract}
\alias{extract}
\title{Extract and combine estimates and goodness-of-fit statistics from several
statistical models.}
\usage{
extract(
  models,
  statistic = "std.error",
  statistic_override = NULL,
  statistic_vertical = TRUE,
  conf_level = 0.95,
  coef_map = NULL,
  coef_omit = NULL,
  gof_map = modelsummary::gof_map,
  gof_omit = NULL,
  add_rows = NULL,
  stars = FALSE,
  fmt = "\%.3f",
  estimate = "estimate",
  add_rows_location = NULL,
  ...
)
}
\arguments{
\item{models}{a single model object or a (potentially named) list of models
to summarize}

\item{statistic}{string name of the statistic to include in parentheses
\itemize{
  \item Typical values: "conf.int", "std.error", "statistic", "p.value"
  \item Alternative values: any column name produced by `broom::tidy(model)`
}}

\item{statistic_override}{manually override the uncertainy estimates. This
argument accepts three types of input:
\itemize{
  \item a function or list of functions of length(models) which produce variance-covariance matrices with row and column names equal to the names of your coefficient estimates. For example, `R` supplies the `vcov` function, and the `sandwich` package supplies `vcovHC`, `vcovHAC`, etc.
  \item a list of length(models) variance-covariance matrices with row and column names equal to the names of your coefficient estimates.
  \item a list of length(models) vectors with names equal to the names of your coefficient estimates. Numeric vectors are formatted according to `fmt` and placed in brackets, character vectors printed as given.
}}

\item{statistic_vertical}{TRUE if statistics should be printed below
estimates. FALSE if statistics should be printed beside estimates.}

\item{conf_level}{confidence level to use for confidence intervals}

\item{coef_map}{named character vector. Names refer to the original variable
names. Values refer to the variable names that will appear in the table.
Coefficients which are omitted from this vector will be omitted from the
table. The table will be ordered in the same order as this vector.}

\item{coef_omit}{string regular expression. Omits all matching coefficients
from the table (using `stringr::str_detect`).}

\item{gof_map}{data.frame with four columns: `raw`, `clean`, `fmt`, and
`omit`. See `modelsummary::gof_map`}

\item{gof_omit}{string regular expression. Omits all matching gof statistics from
the table (using `stringr::str_detect`).}

\item{add_rows}{a data.frame (or tibble) with the following columns: 
\itemize{
  \item section (character): insert in "middle" or "bottom" section of the table
  \item position (integer): row position in the section
  \item term (character): string to display under coefficient names
  \item one column per model with the same name as that model with the
        values to insert (some models can be omitted). 
  \item See the examples section of this documentation and an example.
}}

\item{stars}{to indicate statistical significance
\itemize{
  \item FALSE (default): no significance stars. 
  \item TRUE: *=.1, **=.05, ***=.01
  \item Named numeric vector for custom stars such as `c('*' = .1, '+' = .05)`
}}

\item{fmt}{string which specifies how numeric values will be rounded. This
string is passed to the `sprintf` function. '\%.3f' will keep 3 digits after
the decimal point with trailing zero. '\%.5f' will keep 5 digits. '\%.3e' will
use exponential notation. See `?sprintf` for more options.}

\item{estimate}{character name of the estimate to display. Must be a column
name in the dataframe produced by `tidy(model)`. In the vast majority of
cases, the default value of this argument should not be changed.}

\item{add_rows_location}{This argument is deprecated. Use a data.frame as
described in the documentation for the `add_rows` argument.}

\item{...}{all other arguments are passed to the `tidy` method used to
extract estimates from the model. For example, this allows users to set
`exponentiate=TRUE` to exponentiate logistic regression coefficients.}
}
\value{
tibble
}
\description{
Extract and combine estimates and goodness-of-fit statistics from several
statistical models.
}
\examples{
library(modelsummary)
data(trees)
models <- list()
models[['Bivariate']] <- lm(Girth ~ Height, data = trees)
models[['Multivariate']] <- lm(Girth ~ Height + Volume, data = trees)
extract(models)

}
