% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quality.R
\name{model-quality}
\alias{model-quality}
\alias{mse}
\alias{rmse}
\alias{mae}
\alias{rsquare}
\alias{qae}
\alias{mape}
\alias{rsae}
\title{Compute model quality for a given dataset}
\usage{
mse(model, data)

rmse(model, data)

mae(model, data)

rsquare(model, data)

qae(model, data, probs = c(0.05, 0.25, 0.5, 0.75, 0.95))

mape(model, data)

rsae(model, data)
}
\arguments{
\item{model}{A model}

\item{data}{The dataset}

\item{probs}{Numeric vector of probabilities}
}
\description{
Three summaries are immediately interpretible on the scale of the response
variable:
\itemize{
\item \code{rmse()} is the root-mean-squared-error
\item \code{mae()} is the mean absolute error
\item \code{qae()} is quantiles of absolute error.
}

Other summaries have varying scales and interpretations:
\itemize{
\item \code{mape()} mean absolute percentage error.
\item \code{rsae()} is the relative sum of absolute errors.
\item \code{mse()} is the mean-squared-error.
\item \code{rsquare()} is the variance of the predictions divided by the
variance of the response.
}
}
\examples{
mod <- lm(mpg ~ wt, data = mtcars)
mse(mod, mtcars)
rmse(mod, mtcars)
rsquare(mod, mtcars)
mae(mod, mtcars)
qae(mod, mtcars)
mape(mod, mtcars)
rsae(mod, mtcars)
}
