% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numbers_math.R
\name{dfun.numeric}
\alias{dfun.numeric}
\alias{dfun.array}
\alias{dfun}
\title{Finite Differences}
\usage{
\method{dfun}{numeric}(x, fn)

\method{dfun}{array}(x, fn)

dfun(x, fn)
}
\arguments{
\item{x}{input \code{numeric}}

\item{fn}{function}
}
\value{
Returns the gradient of \code{x}
}
\description{
Estimates the derivate (or gradient) of the
function \code{fn} with respect to the argument
\code{x}
}
\examples{
fn = function(x)x**2
## On scalar arguments
dx_scalar = dfun(3, fn)
print(dx_scalar)
## On matrix (or arrays)
dx_array = dfun(matrix(c(3, 3, 3, 3), 2, 2), fn)
print(dx_array)
}
\author{
Filippo Monari
}
