% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{number.integer}
\alias{number.integer}
\alias{number.numeric}
\alias{number.array}
\alias{number}
\title{Create New Number}
\usage{
\method{number}{integer}(x, dx = TRUE, ...)

\method{number}{numeric}(x, dx = TRUE, scalar = FALSE, ...)

\method{number}{array}(x, dx = TRUE, ...)

number(x, ...)
}
\arguments{
\item{x}{integer, numeric, or array}

\item{dx}{if TRUE to the \code{number} is attributed a derivative}

\item{...}{further arguments, actually ignored}

\item{scalar}{if TRUE the \code{number} is implemented as scalar (rank = 0)}
}
\value{
Returns a reference object of class 'number'
}
\description{
S3 method for creating new \code{numbers}.
}
\examples{
modello.init(n.numbers=10, n.nodes=10, n.graphs=10, n.opts=10)
x = number(integer(3))
print(x)
print(x$v)
modello.close()
modello.init(n.numbers=10, n.nodes=10, n.graphs=10, n.opts=10)
x1 = number(1, scalar=TRUE)
print(x1)
print(x1$v)
x2 = number(1)
print(x2)
print(x2$v)
x3 = number(c(1, 2, 3))
print(x3)
print(x3$v)
modello.close()
modello.init(n.numbers=10, n.nodes=10, n.graphs=10, n.opts=10)
x = number(matrix(rnorm(9), 3, 3))
print(x)
print(x$v)
modello.close()
}
\author{
Filippo Monari
}
