% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_model_arg.R
\name{set_model_arg}
\alias{set_model_arg}
\alias{get_model_arg}
\title{Register Argument for Model}
\usage{
set_model_arg(model, eng, exposed, original, func, has_submodel)

get_model_arg(model, eng)
}
\arguments{
\item{model}{A single character string for the model type (e.g. \code{"k_means"},
etc).}

\item{eng}{A single character string for the model engine.}

\item{exposed}{A single character string for the "harmonized" argument name
that the modeling function exposes.}

\item{original}{A single character string for the argument name that
underlying model function uses.}

\item{func}{A named character vector that describes how to call a function.
\code{func} should have elements \code{pkg} and \code{fun}. The former is optional but is
recommended and the latter is required. For example, \code{c(pkg = "stats", fun = "lm")} would be used to invoke the usual linear regression function. In
some cases, it is helpful to use \code{c(fun = "predict")} when using a
package's \code{predict} method.}

\item{has_submodel}{A single logical for whether the argument can make
predictions on multiple submodels at once.}
}
\value{
A tibble
}
\description{
This function is used to register argument information for a model and engine
combination.
}
\details{
This function needs to be called once for each argument that you are
exposing.
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set_new_model("shallow_learning_model")
set_model_mode("shallow_learning_model", "partition")
set_model_engine("shallow_learning_model", "partition", "stats")

set_model_arg(
  model = "shallow_learning_model",
  eng = "stats",
  exposed = "method",
  original = "method",
  func = list(pkg = "stats", fun = "lm"),
  has_submodel = FALSE
)

get_model_arg("shallow_learning_model", "stats")
get_model_arg("shallow_learning_model", "stats")$func
\dontshow{\}) # examplesIf}
}
