% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_prep.R
\name{add_dummy_variables}
\alias{add_dummy_variables}
\title{Creates dummy variables}
\usage{
add_dummy_variables(df, x, values = c(), auto_values = FALSE,
  remove_original = TRUE)
}
\arguments{
\item{df}{A Local or remote data frame}

\item{x}{Categorical variable}

\item{values}{Possible known values of the categorical variable. If not passed
then the function will take an additional step to figure the unique values of
the variable.}

\item{auto_values}{Safeguard argument to prevent the function from figuring the
unique values if the values argument is empty.  If it is ok for this function
to obtain the unique values, set to TRUE.  Defaults to FALSE.}

\item{remove_original}{It removes the original variable from the returned table.
Defaults to TRUE.}
}
\description{
It uses 'tidyeval' and 'dplyr' to create dummy variables based for
categorical variables.
}
\examples{
library(dplyr)

mtcars \%>\%
  add_dummy_variables(cyl, values = c(4, 6, 8))

mtcars \%>\%
  add_dummy_variables(cyl, auto_values = TRUE)

}
