% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_graph.R
\name{model_graph}
\alias{model_graph}
\title{Generate a Graph of Models}
\usage{
model_graph(
  object,
  node_size_by_x = TRUE,
  x = NULL,
  node_size = 5,
  min_size = 5,
  max_size = 35,
  color_original = "lightblue",
  color_add = "burlywood1",
  color_drop = "lightgreen",
  color_label = "black",
  node_label_size = 1,
  ...
)
}
\arguments{
\item{object}{Must be a
\code{model_set}-class object for now.}

\item{node_size_by_x}{Logical. Whether
node (vertex) sizes are determined
by a variable. Default is \code{TRUE}.
See \code{x} below on how size is
determined.}

\item{x}{If not \code{NULL}, it should be
a numeric vector of length equal to
the number of models. The node sizes
will be proportional to the values
of \code{x}, offset by \code{min_size}. If
\code{NULL}, the default, the BIC
posterior probabilities
stored in \code{object} will be retrieved.}

\item{node_size}{If \code{node_size_by_x}
is \code{FALSE}, this is the size for
all nodes.}

\item{min_size}{The minimum size
of a node. Default is 5.}

\item{max_size}{The maximum size
of a node. Default is 35.}

\item{color_original}{The color
of node of the original model.
Default is \code{"lightblue"}.}

\item{color_add}{The color of
the nodes of models formed by
adding one or more free parameters to
the original model.
Default is \code{"burlywood1"}.}

\item{color_drop}{The color of
the nodes of models formed by
dropping one or more free parameters
from the original model.
Default is \code{"lightgreen"}.}

\item{color_label}{The color of the
text labels of the nodes. Default
is \code{"black"}.}

\item{node_label_size}{The size of
the labels of the nodes. Default is
1.}

\item{...}{Optional arguments. Not
used for now.}
}
\value{
A \code{model_graph}-class object that
can be used as as an \code{igraph}-object,
with a plot method (\code{\link[=plot.model_graph]{plot.model_graph()}})
with settings
suitable for plotting a network
of models with BIC posterior probabilities
computed.
}
\description{
Generate an 'igraph' object from a
'model_set' object.
}
\details{
It extracts the model list stored
in \code{object}, creates an adjacency
matrix, and then creates an \code{igraph}
object customized for visualizing
model relations.
\subsection{Construction of the Graph}{
\itemize{
\item Each model is connected by an
arrow, pointing from one model to
another model that is formed by

a. adding one free parameter, or

b, releasing one equality constraint
between two parameters.
}

That is, it points to a model with
one \emph{less} degree of freedom.
\itemize{
\item By default, the size of the node
for each model is scaled by its
BIC posterior probability, if
available. See \emph{The Size of a Node}
below.
\item The original model, the models with
more degrees of freedom,
and the models with fewer degrees
of freedom are colored differently.
\item The default layout is the Sugiyama
layout, with simpler models (models
with fewer degrees of freedom) on
the top. The lower a model is in
the network, the more the degrees
of freedom it has. This layout is
suitable for showing the nested
relations of the models.
}

The output is an \code{igraph} object.
Users can customize it in any way
they want using functions from
the \code{igraph} package.
}

\subsection{The Size of a Node}{

When a model is scaled by \code{x},
which usually is the BIC posterior
probability, its size is determined
by:

\code{max_size * (x - min(x))/(max(x) - min(x)) + min_size}
}
}
\examples{

library(lavaan)

mod <-
"
m1 ~ x
y ~ m1
"

fit <- sem(mod, dat_serial_4, fixed.x = TRUE)

out <- model_set(fit)
out

g <- model_graph(out)
plot(g)

}
