% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_means.bayesian.R
\name{estimate_means}
\alias{estimate_means}
\title{Estimate average value of response variable at each factor levels}
\usage{
estimate_means(
  model,
  levels = NULL,
  fixed = NULL,
  modulate = NULL,
  transform = "response",
  length = 10,
  ...
)
}
\arguments{
\item{model}{A statistical model.}

\item{levels}{A character vector or formula specifying the names of the predictors over which to estimate means or contrasts.}

\item{fixed}{A character vector indicating the names of the predictors to be "fixed" (i.e., maintained), so that the estimation is made at these values.}

\item{modulate}{A character vector indicating the names of a numeric variable along which the means or the contrasts will be estimated. Adjust its length using \code{length}.}

\item{transform}{Can be \code{"none"} (default for contrasts), \code{"response"} (default for means), \code{"mu"}, \code{"unlink"}, \code{"log"}. \code{"none"}  will leave the values on scale of the linear predictors. \code{"response"} will transform them on scale of the response variable. Thus for a logistic model, \code{"none"} will give estimations expressed in log-odds (probabilities on logit scale) and \code{"response"} in terms of probabilities.}

\item{length}{Length of the spread numeric variables.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A dataframe of estimated marginal means.
}
\description{
See the documentation for your object's class:
\itemize{
 \item{\link[=estimate_means.lm]{Frequentist models}}
 \item{\link[=estimate_means.stanreg]{Bayesian models}}
}
}
