% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/A09_modelObjFit.R
\docType{methods}
\name{predict}
\alias{predict}
\alias{predict,modelObjFit-method}
\title{Model Predictions}
\usage{
predict(object, ...)

\S4method{predict}{modelObjFit}(object, newdata, ...)
}
\arguments{
\item{object}{An object of class \code{modelObjFit} as returned by the 
fit() function.}

\item{newdata}{An object of class data.frame containing the variables in the 
model.}

\item{...}{ignored}
}
\value{
Model predictions, the form of which depend on the regression analysis.
}
\description{
Predictions from the results of a fit object.
}
\examples{
   # generate data
   X <- matrix(rnorm(1000,0,1),
               ncol=4,
               dimnames=list(NULL,c("X1","X2","X3","X4")))

   Y <- X \\\%*\\\% c(0.1, 0.2, 0.3, 0.4) + rnorm(250)

   X <- data.frame(X)

   # create modeling object using a formula
   mo <- buildModelObj(model=Y ~ X1 + X2 + X3 + X4,
                  solver.method='lm')

   # fit model
   fit.obj <- fit(object=mo, data=X, response=Y)

   predict(fit.obj)
   predict(fit.obj, newdata = X[1:10,])

}
