% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{flex}
\alias{flex}
\title{FlexBoost}
\usage{
flex(X, y, n_rounds, interval, width, type, control = rpart.control(cp =
  -1, maxdepth = 1))
}
\arguments{
\item{X}{Variable of train data}

\item{y}{Label of train data}

\item{n_rounds}{How many trees gonna make}

\item{interval}{Parameter to change Exp Loss-Function}

\item{width}{Searching area (more than 1)}

\item{type}{Tie evaluation option  (1 or 2, recommed 2)}

\item{control}{fix cp = -1, maxdepth = 1 based on AdaBoost}
}
\value{
Returns decision tree informations (e.g. Split criteria, Weight of weak classifier, Train accuracy)
}
\description{
A Flexible Boosting Algorithm With Adaptive Loss Functions
}
\details{
This is a main algorithm of FlexBoost: like other Boosting packages, it returns compatible information.
In order to prevent unexpected errors, missing data should not be allowed in input data.
Return value is composed of four major parts (e.g. terms, trees, alphas, acc).
terms : Input variable information
trees : Decision tree information
alphas : Weight of weak classifier
acc : Train accuracy of each iteration
}
\examples{
data <- read.csv(url("http://bit.ly/flex_iris"), TRUE)
flex(data[,1:2], data[,6], 10, 0.1, 3, 2)
}
\keyword{FlexBoost}
