% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnis_additional.R
\name{mnis_basic_details}
\alias{mnis_basic_details}
\alias{mnis_biography_entries}
\alias{mnis_committees}
\alias{mnis_addresses}
\alias{mnis_constituencies}
\alias{mnis_elections_contested}
\alias{mnis_experiences}
\alias{mnis_government_posts}
\alias{mnis_honours}
\alias{mnis_house_memberships}
\alias{mnis_statuses}
\alias{mnis_staff}
\alias{mnis_interests}
\alias{mnis_known_as}
\alias{mnis_maiden_speeches}
\alias{mnis_opposition_posts}
\alias{mnis_other_parliaments}
\alias{mnis_parliamentary_posts}
\alias{mnis_parties}
\alias{mnis_preferred_names}
\title{Additional member information}
\usage{
mnis_basic_details(
  ID = NULL,
  ref_dods = FALSE,
  tidy = TRUE,
  tidy_style = "snake_case"
)

mnis_biography_entries(
  ID = NULL,
  ref_dods = FALSE,
  tidy = TRUE,
  tidy_style = "snake_case"
)

mnis_committees(
  ID = NULL,
  ref_dods = FALSE,
  tidy = TRUE,
  tidy_style = "snake_case"
)

mnis_addresses(
  ID = NULL,
  ref_dods = FALSE,
  tidy = TRUE,
  tidy_style = "snake_case"
)

mnis_constituencies(
  ID = NULL,
  ref_dods = FALSE,
  tidy = TRUE,
  tidy_style = "snake_case"
)

mnis_elections_contested(
  ID = NULL,
  ref_dods = FALSE,
  tidy = TRUE,
  tidy_style = "snake_case"
)

mnis_experiences(
  ID = NULL,
  ref_dods = FALSE,
  tidy = TRUE,
  tidy_style = "snake_case"
)

mnis_government_posts(
  ID = NULL,
  ref_dods = FALSE,
  tidy = TRUE,
  tidy_style = "snake_case"
)

mnis_honours(
  ID = NULL,
  ref_dods = FALSE,
  tidy = TRUE,
  tidy_style = "snake_case"
)

mnis_house_memberships(
  ID = NULL,
  ref_dods = FALSE,
  tidy = TRUE,
  tidy_style = "snake_case"
)

mnis_statuses(
  ID = NULL,
  ref_dods = FALSE,
  tidy = TRUE,
  tidy_style = "snake_case"
)

mnis_staff(ID = NULL, ref_dods = FALSE, tidy = TRUE, tidy_style = "snake_case")

mnis_interests(
  ID = NULL,
  ref_dods = FALSE,
  tidy = TRUE,
  tidy_style = "snake_case"
)

mnis_known_as(
  ID = NULL,
  ref_dods = FALSE,
  tidy = TRUE,
  tidy_style = "snake_case"
)

mnis_maiden_speeches(
  ID = NULL,
  ref_dods = FALSE,
  tidy = TRUE,
  tidy_style = "snake_case"
)

mnis_opposition_posts(
  ID = NULL,
  ref_dods = FALSE,
  tidy = TRUE,
  tidy_style = "snake_case"
)

mnis_other_parliaments(
  ID = NULL,
  ref_dods = FALSE,
  tidy = TRUE,
  tidy_style = "snake_case"
)

mnis_parliamentary_posts(
  ID = NULL,
  ref_dods = FALSE,
  tidy = TRUE,
  tidy_style = "snake_case"
)

mnis_parties(
  ID = NULL,
  ref_dods = FALSE,
  tidy = TRUE,
  tidy_style = "snake_case"
)

mnis_preferred_names(
  ID = NULL,
  ref_dods = FALSE,
  tidy = TRUE,
  tidy_style = "snake_case"
)
}
\arguments{
\item{ID}{The member ID. If \code{NULL}, function calls
\code{\link[=mnis_all_members]{mnis_all_members()}} and returns basic information on all
members of both houses. Defaults to \code{NULL}.}

\item{ref_dods}{If \code{TRUE}, Request based on the DODS membership ID
scheme. If \code{FALSE}, requests data based on the default membership
ID scheme. Defaults to \code{FALSE}.}

\item{tidy}{If \code{TRUE}, fixes the variable names in the tibble to
remove non-alphanumeric characters and superfluous text, and convert to
a consistent style. Defaults to \code{TRUE}.}

\item{tidy_style}{The style to convert variable names to, if
\code{tidy=TRUE}. Accepts one of \code{"snake_case"}, \code{"camelCase"} and
\code{"period.case"}. Defaults to \code{"snake_case"}.}
}
\value{
A list with the data corresponding to the particular function
called.
}
\description{
A series of basic function for the API lookup. Each of these functions
accepts a member's ID and returns information; if no ID is given basic
information on all members of both houses is returned.
All functions return basic details about the member (name, date of birth,
gender, constituency, party, IDs, current status, etc.), as well as any
available additional information requested by the specific function.
}
\section{\code{mnis_additional} functions}{

\itemize{
\item \code{mnis_basic_details} Basic biographical details
on a given Member
\item \code{mnis_biography_entries} Member biographical information (e.g.
countries of interest, policy expertise etc...)
\item \code{mnis_committees} Committees a Member sits or has sat on as
well details on committee chairing
\item \code{mnis_addresses} Member address information (e.g. website,
twitter, constituency address etc...)
\item \code{mnis_constituencies} Constituencies a Member has represented
\item \code{mnis_elections_contested} Elections a Member has
contested but not won
\item \code{mnis_experiences} Non-parliamentary experience of a Member
\item \code{mnis_government_posts} Government posts a Member has held
\item \code{mnis_honours} Honours (e.g. MBE, OBE etc...) held by a Member
\item \code{mnis_house_memberships} House membership list of a Member
\item \code{mnis_statuses} Status history (e.g. suspensions and
disqualifications) for a Member
\item \code{mnis_staff} The staff employed by a Member
\item \code{mnis_interests} Registered (financial) interests
of a Member
\item \code{mnis_known_as} Details of names a Member has chosen to
be known as instead of their full title, only applicable to members
of the House of Lords
\item \code{mnis_maiden_speeches} Maiden speech dates for a Member
\item \code{mnis_opposition_posts} Opposition posts a Member has held
\item \code{mnis_other_parliaments} Other Parliaments that a Member has held
a membership of (e.g. members of the Welsh Assembly)
\item \code{mnis_parliamentary_posts} Parliamentary posts
a Member has held
\item \code{mnis_parties} Party affiliations of a Member
\item \code{mnis_preferred_names} Full set of data about a
Members' name (e.g. surname, forename, Honorary prefixes, full
details of House of Lords title and rank if applicable, etc...)
}
}

\examples{
\dontrun{
x <- mnis_basic_details(172)
}

}
\seealso{
\code{\link[=mnis_full_biog]{mnis_full_biog()}}
}
