% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmb-methods.R
\name{h_construct_model_frame_inputs}
\alias{h_construct_model_frame_inputs}
\title{Construction of Model Frame Formula and Data Inputs}
\usage{
h_construct_model_frame_inputs(
  formula,
  data,
  include,
  include_choice = c("subject_var", "visit_var", "group_var", "response_var"),
  full
)
}
\arguments{
\item{formula}{(\code{mmrm})\cr mmrm fit object.}

\item{data}{optional data frame that will be
passed to \code{model.frame()} or \code{model.matrix()}}

\item{include}{(\code{character})\cr names of variable to include}

\item{full}{(\code{flag})\cr indicator whether to return full model frame (deprecated).}
}
\value{
named list with four elements:
\itemize{
\item \code{"formula"}: the formula including the columns requested in the \verb{include=} argument.
\item \code{"formula_full"}: the formula including all columns
\item \code{"data"}: a data frame including all columns where factor and
character columns have been processed with \code{\link[=h_factor_ref]{h_factor_ref()}}.
\item \code{"is_full"}: a logical scalar indicating if the formula and
full formula are identical
}
}
\description{
Input formulas are converted from mmrm-style to a style compatible
with default \code{\link[stats:model.frame]{stats::model.frame()}} and \code{\link[stats:model.matrix]{stats::model.matrix()}} methods.

The full formula is returned so we can construct, for example, the
\code{model.frame()} including all columns as well as the requested subset.
The full set is used to identify rows to include in the reduced model frame.
}
\keyword{internal}
