% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rc_game_mgmt.R
\name{deal_cards_to_rc_grid}
\alias{deal_cards_to_rc_grid}
\title{Deal Cards to a RepliCrisis Grid}
\usage{
deal_cards_to_rc_grid(
  deck = mmcards::i_deck(deck = mmcards::shuffle_deck(), i_path = "www", i_names =
    c("2_of_clubs", "2_of_diamonds", "2_of_hearts", "2_of_spades", "3_of_clubs",
    "3_of_diamonds", "3_of_hearts", "3_of_spades", "4_of_clubs", "4_of_diamonds",
    "4_of_hearts", "4_of_spades", "5_of_clubs", "5_of_diamonds", "5_of_hearts",
    "5_of_spades", "6_of_clubs", "6_of_diamonds", "6_of_hearts", "6_of_spades",
    "7_of_clubs", "7_of_diamonds", "7_of_hearts", "7_of_spades", "8_of_clubs",
    "8_of_diamonds", "8_of_hearts", "8_of_spades", 
     "9_of_clubs", "9_of_diamonds",
    "9_of_hearts", "9_of_spades", "10_of_clubs", "10_of_diamonds", "10_of_hearts",
    "10_of_spades", "jack_of_clubs", "jack_of_diamonds", "jack_of_hearts",
    "jack_of_spades", "queen_of_clubs", "queen_of_diamonds", "queen_of_hearts",
    "queen_of_spades", "king_of_clubs", "king_of_diamonds", "king_of_hearts",
    "king_of_spades", "ace_of_clubs", "ace_of_diamonds", "ace_of_hearts",
    "ace_of_spades")),
  n
)
}
\arguments{
\item{deck}{A data frame representing a deck of cards, which by default is a
shuffled standard deck from the \code{mmcards} package.}

\item{n}{The number of card pairs to deal. The function will deal 2*n cards
and arrange them into two rows, for the RepliCrisis grid.}
}
\value{
A matrix with two rows and n columns, representing the dealt cards
arranged into pairs.
}
\description{
This function deals cards from a shuffled deck and arranges them into a matrix
suitable for the RepliCrisis game grid.
}
\details{
The function first checks if there are enough cards in the deck to deal the
required number of pairs. If not, it stops with an error. Then, it deals 2*n
cards from the provided deck, reshaping them into a 2-row matrix where each
column represents a pair of cards.

If no deck is provided, the function will shuffle a standard deck using
functions from the \code{mmcards} package. The default deck includes all standard
52 playing cards.

The grid of cards will be used by the generate_study_data function to generate
data for n groups where the values for each group are simulated from a normal
distribution with mean and standard deviation defined by the values in the card
pair.
}
\examples{
# Deal a grid with 3 card pairs
grid <- deal_cards_to_rc_grid(n = 3)
}
