% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeDatamlx.R
\name{writeDatamlx}
\alias{writeDatamlx}
\title{Write formatted data file}
\usage{
writeDatamlx(r, result.file = NULL, result.folder = NULL, sep = ",",
  ext = NULL, digits = 5, app.file = F, app.dir = F)
}
\arguments{
\item{r}{a list of dataframes}

\item{result.file}{a string with the name of the file}

\item{result.folder}{a string with the name of the folder}

\item{sep}{(default = ",")}

\item{ext}{a string with the extension of the file names}

\item{digits}{(default = 5)}

\item{app.file}{TRUE/FALSE (default=FALSE) append to file}

\item{app.dir}{TRUE/FALSE (default=FALSE) append to dir}
}
\description{
Write data contained in a list of dataframes in a single file (NONMEM/Monolix format)
or in several files as tables
}
\details{
See http://simulx.webpopix.org/mlxr/writedatamlx/ for more details.
}
\examples{
\dontrun{
modelPK <- inlineModel("
[LONGITUDINAL]
input = {V, Cl, a1}
EQUATION:
Cc = pkmodel(V, Cl)
DEFINITION:
y1 ={distribution=lognormal, prediction=Cc, sd=a1}
")
adm  <- list(amount=100, time=seq(0,50,by=12))
p <- c(V=10, Cl=1, a1=0.1)
y1 <- list(name=c('y1'), time=seq(5,to=50,by=5))
res <- simulx(model=modelPK, treatment=adm, parameter=p, output=y1)
writeDatamlx(res, result.file="res.csv")
writeDatamlx(res, result.file="res.txt", sep="\\t")
writeDatamlx(res, result.folder="res")
}
}

