% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{getCPOPredictType}
\alias{getCPOPredictType}
\alias{PredictType}
\alias{getCPOPredictType.CPOTrained}
\title{Get the CPO \code{predict.type}}
\usage{
getCPOPredictType(cpo)

\method{getCPOPredictType}{CPOTrained}(cpo)
}
\arguments{
\item{cpo}{[\code{\link{CPO}}]\cr
The cpo.}
}
\value{
[\code{character}]. A named \code{character} that maps potential predict types that a CPO may provide to the required
predict type of an underlying learner.
}
\description{
Get the possible predict.types a \code{\link{CPO}} is able to handle.

The concept of a \code{predict.type} originates from \code{\link[mlr]{predict.WrappedModel}}, which
allows the estimation of different aspects of a prediction. This is, currently:
\describe{
  \item{\dQuote{response}}{A best estimate of the actual target value}
  \item{\dQuote{prob}}{An estimate of probabilities of different target values}
  \item{\dQuote{se}}{An estimate of the target value, together with an estimate of the standard error of this first estimation}
}

A Target Operation CPO is able to change the type of a \code{\link[mlr]{Task}}, but it can also enhance the type of predictions
that a \code{\link[mlr:makeLearner]{Learner}} can make for it. Thus a CPO that converts a binary classification into a regression task can
use a regression learner to not only predict the \dQuote{response} class, but also the estimated probability (\dQuote{prob})
distribution over the two classes. For this, the CPO declares
\enumerate{
  \item what \code{predict.type}s a \code{\link[mlr:makeLearner]{Learner}}, when attached to it, can provide, and
  \item what \code{predict.type} the \code{\link[mlr:makeLearner]{Learner}}, in each case, must be capable of.
}
This information is provided in the form of a named \code{character}, where the names are the provided predict type capabilities,
and the values are the predict type that the underlying \code{\link[mlr:makeLearner]{Learner}} must provide for this.

The CPO converting classification to regression mentioned above would thus have the \code{predict.type} of:

\code{c(response = "response", prob = "response")}

Another example would be a CPO that converts a multiclass classification problem into an ordinary classification problem, but
uses the \dQuote{prob} prediction of the underlying learner to make both the \dQuote{response} and \dQuote{prob} predictions.
It would have the \code{predict.type} of:

\code{c(response = "prob", prob = "prob")}

If this second CPO is attached to a \code{\link[mlr:makeLearner]{Learner}} that does not have the \dQuote{prob} property (see
\code{\link[mlr]{LearnerProperties}}), an error is given.

CPOs that are not Target Operating always have the \code{predict.type} of:

\code{c(response = "response", prob = "prob", se = "se")}
}
\seealso{
Other getters and setters: 
\code{\link{CPO}},
\code{\link{getCPOAffect}()},
\code{\link{getCPOClass}()},
\code{\link{getCPOConstructor}()},
\code{\link{getCPOId}()},
\code{\link{getCPOName}()},
\code{\link{getCPOOperatingType}()},
\code{\link{getCPOProperties}()},
\code{\link{getCPOTrainedCPO}()},
\code{\link{getCPOTrainedCapability}()},
\code{\link{setCPOId}()}

Other retrafo related: 
\code{\link{CPOTrained}},
\code{\link{NULLCPO}},
\code{\link{\%>>\%}()},
\code{\link{applyCPO}()},
\code{\link{as.list.CPO}},
\code{\link{clearRI}()},
\code{\link{getCPOClass}()},
\code{\link{getCPOName}()},
\code{\link{getCPOOperatingType}()},
\code{\link{getCPOProperties}()},
\code{\link{getCPOTrainedCPO}()},
\code{\link{getCPOTrainedCapability}()},
\code{\link{getCPOTrainedState}()},
\code{\link{is.retrafo}()},
\code{\link{makeCPOTrainedFromState}()},
\code{\link{pipeCPO}()},
\code{\link{print.CPOConstructor}()}

Other inverter related: 
\code{\link{CPOTrained}},
\code{\link{NULLCPO}},
\code{\link{\%>>\%}()},
\code{\link{applyCPO}()},
\code{\link{as.list.CPO}},
\code{\link{clearRI}()},
\code{\link{getCPOClass}()},
\code{\link{getCPOName}()},
\code{\link{getCPOOperatingType}()},
\code{\link{getCPOProperties}()},
\code{\link{getCPOTrainedCPO}()},
\code{\link{getCPOTrainedCapability}()},
\code{\link{getCPOTrainedState}()},
\code{\link{is.inverter}()},
\code{\link{makeCPOTrainedFromState}()},
\code{\link{pipeCPO}()},
\code{\link{print.CPOConstructor}()}
}
\concept{getters and setters}
\concept{inverter related}
\concept{retrafo related}
