% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BenchmarkResult.R
\name{autoplot.BenchmarkResult}
\alias{autoplot.BenchmarkResult}
\title{Plot for BenchmarkResult}
\usage{
\method{autoplot}{BenchmarkResult}(object, type = "boxplot", measure = NULL, ...)
}
\arguments{
\item{object}{(\link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult}).}

\item{type}{(character(1)):\cr
Type of the plot. See description.}

\item{measure}{(\link[mlr3:Measure]{mlr3::Measure})\cr
Performance measure to use.}

\item{...}{(\code{any}):
Additional arguments, passed down to the respective \code{geom} or plotting function.}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
Generates plots for \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult}, depending on argument \code{type}:
\itemize{
\item \code{"boxplot"} (default): Boxplots of performance measures, one box per
\link[mlr3:Learner]{mlr3::Learner} and one facet per \link[mlr3:Task]{mlr3::Task}.
\item \code{"roc"}: ROC curve (1 - specificity on x, sensitivity on y).
The \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult} may only have a single \link[mlr3:Task]{mlr3::Task} and a
single \link[mlr3:Resampling]{mlr3::Resampling}.
Note that you can subset any \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult} with its \verb{$filter()}
method (see examples).
Requires package \CRANpkg{precrec}.
Additional arguments will be passed down to the respective \code{\link[=autoplot]{autoplot()}} function
in package \CRANpkg{precrec}. Arguments \code{calc_avg} and \code{cb_alpha} are passed to
\code{\link[precrec:evalmod]{precrec::evalmod()}}.
\item \code{"prc"}: Precision recall curve. See \code{"roc"}.
}
}
\examples{
library(mlr3)
library(mlr3viz)

tasks = tsks(c("pima", "sonar"))
learner = lrns(c("classif.featureless", "classif.rpart"),
  predict_type = "prob")
resampling = rsmps("cv")
object = benchmark(benchmark_grid(tasks, learner, resampling))

head(fortify(object))
autoplot(object)
autoplot(object$clone(deep = TRUE)$filter(task_ids = "pima"), type = "roc")
}
\references{
Saito T, Rehmsmeier M (2017).
\dQuote{Precrec: fast and accurate precision-recall and ROC curve calculations in R.}
\emph{Bioinformatics}, \bold{33}(1), 145-147.
\doi{10.1093/bioinformatics/btw570}.
}
