% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TuningInstanceSingleCrit.R
\name{autoplot.TuningInstanceSingleCrit}
\alias{autoplot.TuningInstanceSingleCrit}
\title{Plot for TuningInstanceSingleCrit}
\usage{
\method{autoplot}{TuningInstanceSingleCrit}(
  object,
  type = "marginal",
  cols_x = NULL,
  trafo = FALSE,
  learner = mlr3::lrn("regr.ranger"),
  grid_resolution = 100,
  ...
)
}
\arguments{
\item{object}{(\link[mlr3tuning:TuningInstanceSingleCrit]{mlr3tuning::TuningInstanceSingleCrit}.}

\item{type}{(\code{character(1)}):
Type of the plot. Available choices:
\itemize{
\item \code{"marginal"}: scatter plots of hyperparameter versus performance. The
colour of the points shows the batch number.
\item \code{"performance"}: scatter plots of batch number versus performance.
\item \code{"parameter"}: scatter plots of batch number versus hyperparameter. The
colour of the points shows the performance.
\item \code{"parallel"} parallel coordinates plot. Parameter values are rescaled by
\code{(x - mean(x)) / sd(x)}.
\item \code{"points"} - scatter plot of two hyperparameters versus performance. The
colour of the points shows the performance.
\item \code{"surface"}: surface plot of 2 hyperparameters versus performance.
The performance values are interpolated with the supplied
\link[mlr3:Learner]{mlr3::Learner}.
}}

\item{cols_x}{(\code{character()})\cr
Column names of hyperparameters. By default, all untransformed
hyperparameters are plottet. Transformed hyperparameters are prefixed with
\code{x_domain_}.}

\item{trafo}{(\code{logical(1)})\cr
Determines if untransformed (\code{FALSE}) or transformed (\code{TRUE})
hyperparametery are plotted.}

\item{learner}{(\link[mlr3:Learner]{mlr3::Learner})\cr
Regression learner used to interpolate the data of the surface plot.}

\item{grid_resolution}{(\code{numeric()})\cr
Resolution of the surface plot.}

\item{...}{(\code{any}):
Additional arguments, possibly passed down to the underlying plot functions.}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
Generates plots for \link[mlr3tuning:TuningInstanceSingleCrit]{mlr3tuning::TuningInstanceSingleCrit}.
}
\examples{
if(requireNamespace("mlr3tuning") && requireNamespace("patchwork")) {
library(mlr3tuning)

learner = lrn("classif.rpart")
learner$param_set$values$cp = to_tune(0.001, 0.1)
learner$param_set$values$minsplit = to_tune(1, 10)

instance = TuningInstanceSingleCrit$new(
  task = tsk("iris"),
  learner = learner,
  resampling = rsmp("holdout"),
  measure = msr("classif.ce"),
  terminator = trm("evals", n_evals = 10))

tuner = tnr("random_search")

tuner$optimize(instance)

# plot performance versus batch number
autoplot(instance, type = "performance")

# plot cp values versus performance
autoplot(instance, type = "marginal", cols_x = "cp")

# plot transformed parameter values versus batch number
autoplot(instance, type = "parameter", trafo = TRUE)

# plot parallel coordinates plot
autoplot(instance, type = "parallel")}
}
